//------------------------------------------------------------------------------
//
//  Include fle for the Matrix Multiply test harness 
//
//  HISTORY: Written by Tim Mattson, August 2010 
//
//------------------------------------------------------------------------------

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#if defined(__APPLE__) || defined(MACOSX)
    #include <OpenCL/opencl.h>
#else
    #include <CL/opencl.h>
#endif

#include "matrix_lib.h"
 
//------------------------------------------------------------------------------
//  functions from ../Common
//------------------------------------------------------------------------------
extern int    output_device_info(cl_device_id );
extern int    err_code(cl_int);
extern double wtime();   // returns time since some fixed past point (wtime.c)

//------------------------------------------------------------------------------
//  Constants
//------------------------------------------------------------------------------
#define ORDER    1000    // Order of the square matrices A, B, and C
#define AVAL     3.0     // A elements are constant and equal to AVAL
#define BVAL     5.0     // B elements are constant and equal to BVAL
#define TOL      (0.001) // tolerance used in floating point comparisons
#define DIM      2       // Max dim for NDRange
#define COUNT    3       // number of times to do each multiplication
#define SUCCESS  1     
#define FAILURE  0     

