//------------------------------------------------------------------------------
//
//  Include fle listing functon prototypes for kernels accessed from the driver
//
//  HISTORY: Written by Tim Mattson, August 2010 
//
//------------------------------------------------------------------------------

int setup_kern_c_elem(
   cl_device_id   device_id,  // compute device id 
   cl_context     context,    // compute context
   int           Ndim,       // number of rows in A and C
   int           Pdim,       // number of rows for B and columns for A
   int           Mdim,       // number of columns in B and C  
   cl_mem        a_in,       // device memory used for the input  a vector
   cl_mem        b_in,       // device memory used for the input  b vector
   cl_mem        c_out,      // device memory used for the output c vector
   cl_program    *program,    // compute program
   cl_kernel     *kernel,     // compute kernel
   size_t        *global,     // global domain size  
   cl_uint       *nd);      // Number of dimensions in NDRange


int setup_kern_c_row(
   cl_device_id   device_id,  // compute device id 
   cl_context     context,    // compute context
   int           Ndim,       // number of rows in A and C
   int           Pdim,       // number of rows for B and columns for A
   int           Mdim,       // number of columns in B and C  
   cl_mem        a_in,       // device memory used for the input  a vector
   cl_mem        b_in,       // device memory used for the input  b vector
   cl_mem        c_out,      // device memory used for the output c vector
   cl_program    *program,    // compute program
   cl_kernel     *kernel,     // compute kernel
   size_t        *global,     // global domain size  
   size_t        *local,      // local  domain size  
   cl_uint       *nd);      // Number of dimensions in NDRange


int setup_kern_c_row_priv(
   cl_device_id   device_id,  // compute device id 
   cl_context     context,    // compute context
   int           Ndim,       // number of rows in A and C
   int           Pdim,       // number of rows for B and columns for A
   int           Mdim,       // number of columns in B and C  
   cl_mem        a_in,       // device memory used for the input  a vector
   cl_mem        b_in,       // device memory used for the input  b vector
   cl_mem        c_out,      // device memory used for the output c vector
   cl_program    *program,    // compute program
   cl_kernel     *kernel,     // compute kernel
   size_t        *global,     // global domain size  
   size_t        *local,      // local  domain size  
   cl_uint       *nd);      // Number of dimensions in NDRange

int setup_kern_c_row_priv_bloc(
   cl_device_id   device_id,  // compute device id 
   cl_context     context,    // compute context
   int           Ndim,       // number of rows in A and C
   int           Pdim,       // number of rows for B and columns for A
   int           Mdim,       // number of columns in B and C  
   cl_mem        a_in,       // device memory used for the input  a vector
   cl_mem        b_in,       // device memory used for the input  b vector
   cl_mem        c_out,      // device memory used for the output c vector
   cl_program    *program,    // compute program
   cl_kernel     *kernel,     // compute kernel
   size_t        *global,     // global domain size  
   size_t        *local,      // local  domain size  
   cl_uint       *nd);      // Number of dimensions in NDRange


