package XCSphere;

/* 
 * A Boolean function defined as 1 if the current state is within a particular 
 * sphere. The sphere is defined as any point within a fixed hamming distance of a 
 * particular point. Both point and distance are currently constants but could be
 * made arguments so that this class implements many Boolean functions.
 *
 * At the moment this class contained commented-out code to implement
 * other boolean functions. It's easier to switch between them by adding/removing
 * comments than to set up a new class for each, mainly because new classes
 * require updates to XCSphere.main(). (Which should be changed....)
 */

public class SphereEnvironment1 extends BooleanEnvironment {

	private final int thresholdDistance = 1;
	private final char[] point = {'0','0','0','0','0','0'};
	//private final char[] point = {'1','1','1','1','1','1'};
	
    /**
     * @param length Specifies the problem length.
     * @param payoffMap -- not used
     * @param trackInstancesSeen Enables counting of unique problem instances seen (only suitable for small problems)
     */
    public SphereEnvironment1(int length, int payoffMap, boolean trackInstancesSeen)
    {
     super(length,trackInstancesSeen);
    }
    
    /** 
     * Implements the sphere boolean function.
     * @param action XCS' classification of the currentState 
     */
    public boolean isCorrect(int action)
    {
    	int stateValue = 0;
 
    	// check whether currentState is within the sphere
    	if (hammingDistance(currentState, point) <= thresholdDistance)
    		stateValue = 1;
    	else
    		stateValue = 0;
    	
    	// or within the plane
//    	if ((currentState[0] == '1') &&
//    		(currentState[1] == '1') &&
//    		(currentState[2] == '1') &&
//    		(currentState[3] == '1'))
//    		stateValue = 1;

//    	if (currentState[0] == '1')
//    		stateValue = 1;
    	
    	if (action == stateValue)
    		return true;
    	else
    		return false;
    }

    /* A different function
    public boolean isCorrect(int action) {
       	int stateValue = 0;
        
    	// check whether currentState is within the sphere
    	if (hammingDistance(currentState, point) <= thresholdDistance)
    		stateValue = 1;
    	
    	// or within the plane
    	if ((currentState[0] == '0') &&
    		(currentState[1] == '0'))
    		stateValue = 1;
    	
    	if (action == stateValue)
    		return true;
    	else
    		return false;
    } */

    
    /**
     * Returns the hamming distance between two character arrays
     */    
	private int hammingDistance(char[] one, char[] two) {
		int distance = 0;

		for (int l1 = 0; l1 < one.length; l1++) 
			if (one[l1] != two[l1]) 
				distance++;
		return distance;
	}
	
}
