package XCSphere;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * This class implements the class of 7-bit boolean functions that can be described with sixteen hyperspheres.
 * @author    James Marshall
 */
public class SixteenSphereEnvironment extends BooleanEnvironment implements Environment
{
	ArrayList mSpheres;
	
    /**
     * @param length Specifies the problem length (must be 7).
     * @param payoffMap -- not used
     * @param trackInstancesSeen Enables counting of unique problem instances seen (only suitable for small problems)
     */
    public SixteenSphereEnvironment(int length, int payoffMap, boolean trackInstancesSeen)
    {
        super(length,trackInstancesSeen);
        
    	if(length != 7)
    	{
    		throw new IllegalArgumentException("SixteenSphereEnvironment must have length 7");
    	}
    	
    	mSpheres = new ArrayList(16);
    	mSpheres.add(new String("0000000"));
    	mSpheres.add(new String("1110000"));
    	mSpheres.add(new String("1001100"));
    	mSpheres.add(new String("0101010"));
    	mSpheres.add(new String("1101001"));
    	mSpheres.add(new String("0011001"));
    	mSpheres.add(new String("1011010"));
    	mSpheres.add(new String("0111100"));
    	mSpheres.add(new String("0100101"));
    	mSpheres.add(new String("1100110"));
    	mSpheres.add(new String("0010110"));
    	mSpheres.add(new String("1010101"));
    	mSpheres.add(new String("1000011"));
    	mSpheres.add(new String("0110011"));
    	mSpheres.add(new String("0001111"));
    	mSpheres.add(new String("1111111"));
    }

    /**
     * Implements the sixteen sphere function on the current state and compare to the
     * current action.
     *
     * @param action Specifies the classification.
     */
    public boolean isCorrect(int action)
    {
    	String condition;
    	int stateValue = 0, hammingDistance;
    	Iterator i;
    	int l1, l2;
    	
    	for (l1 = 0; l1 < mSpheres.size(); l1++)
    	{
    		hammingDistance = 0;
    		condition = (String) mSpheres.get(l1);
    		for (l2 = 0; l2 < condition.length(); l2++)
    		{
    			if (condition.charAt(l2) != currentState[l2])
    			{
    				hammingDistance++;
    			}
    		}
    		if (hammingDistance <= 1)
    		{
    			stateValue = l1 % 2;
    		}
    	}
	
    	if (action == stateValue)
    		return true;
    	else	
    		return false;
    }
}
