package XCSphere;

/**
 * This class implements the Parity (boolean function) problem.
 * @author    Tim Kovacs
 * @version   XCSJava 1.0 <-- no
 * @since     JDK1.1
 */
public class ParityEnvironment extends BooleanEnvironment implements Environment
{
    /**
     * @param length Specifies the problem length.
     * @param payoffMap -- not used
     * @param trackInstancesSeen Enables counting of unique problem instances seen (only suitable for small problems)
     */
    public ParityEnvironment(int length, int payoffMap, boolean trackInstancesSeen)
    {
     super(length,trackInstancesSeen);
    }


    /**
     * Implements the parity function on the current state and compare to the
     * current action.
     *
     * @param action Specifies the classification.
     */
    public boolean isCorrect(int action)
    {
	int oneBits = 0;
	for(int i=0; i<conLength; i++){
	    if(currentState[i]=='1'){
		oneBits ++;
	    }
	}
	// set stateValue to 0 if there are an even number of one bits, 1 otherwise
	int stateValue = oneBits % 2;

	//	System.out.println("Current state = " + new String(currentState) + " action = " + action +
	//			" value = " + stateValue + " correct = " + (action == stateValue));
	
	if(action == stateValue)
		return true;
	else
		return false;
    }
}
