%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Predicts the class given a test input and the population
% [cl cl_ratio pred1_cl pred0_cl nmatches] = ucspredict(pop,x)
% I/P arguments -
%	pop - population of rules
%	x - test input string
% O/P arguments -
%	cl - class prediction
%	cl_ratio - ratio of class supports
%	pred1_cl - class support for class 1
%	pred0_cl - class support for class 0
%	nmatches - number of matches for the entire test set
function [cl cl_ratio pred1_cl pred0_cl nmatches] = ucspredict(pop,x)
[N D] = size(x);
cl = zeros(N,1);
f = fitness(pop);f = f';
nmatches = 0;
for i = 1:N
    matchset = match(pop,x(i,:));
    nmatches = nmatches + (1-isempty(matchset));
    ind1 = find(pop.action(matchset) == 1);
    ind0 = find(pop.action(matchset) == 0);
    if (isempty(ind1))
        pred1 = 0;
    else
        pred1 = sum(f(matchset(ind1)).*pop.n(matchset(ind1)))/sum(pop.n(matchset(ind1)));
    end;
    if (isempty(ind0))
        pred0 = 0;
    else
        pred0 = sum(f(matchset(ind0)).*pop.n(matchset(ind0)))/sum(pop.n(matchset(ind0)));
    end;
    cl(i,1) = pred1 > pred0;
    mi = min(pred1,pred0);
    ma = max(pred1,pred0);
    if (mi == 0 && ma == 0)
        cl_ratio(i,1) = 1;
    else
        cl_ratio(i,1) = mi/ma;
    end;
    %cl_ratio(i) = abs(pred1 - pred0);
    if (pred1 == 0 && pred0 == 0)
        pred1 = 0.5; pred0 = 0.5;
    end;
    s = pred1 + pred0;
    pred1_cl(i,1) = pred1/s;
    pred0_cl(i,1) = pred0/s;
end;
