%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


clear;

% build the mux-6 dataset
no_addr_bits = 2; % number of address bits
no_data_bits = 2^no_addr_bits;
D = no_addr_bits + no_data_bits;
N = 2^D;

% input data
X = changebase(0:(N - 1),2,D);

format_str = '';

for j = 1:D
    format_str = strcat(format_str,'%d');
end;

for i = 1:(2^D)
    % convert from a vector of bits to a string
    addr_bin_str = sprintf(format_str,X(i,1:no_addr_bits));
    % convert from binary to decimal number
    dec_no = bin2dec(addr_bin_str);
    % class is the bit in the data part addressed by dec_no
    C(i,1) = X(i,dec_no+no_addr_bits+1);
end;

% split into train (75%) and test (25%)
Ntr = ceil(N*0.75);

for i = 1:10
    rand('seed',i);
    % get a random permutation
    ind = randperm(2^D);
    
    % training data
    trX = X(ind(1:Ntr),:); trC = C(ind(1:Ntr));
    % test data
    teX = X(ind((Ntr+1):N),:); teC = C(ind((Ntr+1):N));
    
    % initialise population with all the parameters
    pop = initpop(D);
    
    % train the ucs collecting the statistics
    maxIter = 1000;
    % providing the test data is optional if not you can give
    % [pop trErr(i,:) teErr(i,:)] = ucstrain(pop,trX,trC,maxIter);
    [pop trErr(i,:) teErr(i,:)] = ucstrain(pop,trX,trC,maxIter,teX,teC);
end;

plot(1:maxIter,mean(trErr),1:maxIter,mean(teErr),'LineWidth',2);
legend('Train Error','Test Error');
xlabel('# training data pts. presented');
ylabel('error');
