%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Function used to mutate a condition string
% [indiv action] = mutation(indiv,prob)
% I/P arguments -
%	indiv - the individuals that need to be mutated
%	prob - the probability of a bit being mutated
% O/P arguments -
%	indiv - the mutated version of individuals
%	action - mutated class label
function [indiv action] = mutation(indiv,prob)
[N D] = size(indiv);
flipbits = ceil(rand(N,D)*2);
suppressbits = (rand(N,D) < prob);
indiv = mod(indiv + flipbits.*suppressbits,3);
action = randi(2,N,1) - 1;
