%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Match an individual to a set of rules in the population
% ind = match(pop,x)
% I/P arguments
%   pop - population structure containing the rules
%   x - the input string to match
% O/P arguments
%   ind - indices of the matching rules
function ind = match(pop,x)
[N D] = size(x);
ind = [];
if (isempty(pop.rules))
    return;
end;
[popN popD] = size(pop.rules);
for j = 1:popD
    ind2 = find(pop.rules(:,j) == 2);
    pop.rules(ind2,j) = x(j);
end;
ind = find(all(pop.rules == repmat(x,popN,1),2) == 1);
