%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Function that uses GA operators to shape the population
% pop = invokeGA(pop,actionset)
% I/P arguments -
%   pop - population of rules
%   actionset - the set of rules that have been included in the actionset
%   GA is run only on the action set
% O/P arguments -
%   pop - population of rules after a run of the GA
function pop = invokeGA(pop,actionset)
[N D] = size(pop.rules);

momind = selOffspring(pop,actionset);
dadind = selOffspring(pop,actionset);

if(rand(1) < pop.crossoverProb)
    % Crossover
    crosspoint = ceil(rand(1)*D);
    indiv(1,:) = [pop.rules(momind,1:crosspoint) pop.rules(dadind,(crosspoint+1):D)];
    indiv(2,:) = [pop.rules(dadind,1:crosspoint) pop.rules(momind,(crosspoint+1):D)];
    md_ind = [momind dadind];
    correctSetSize = mean(pop.correctSetSize(md_ind))*ones(1,2);
    numMatches = zeros(1,2);
    numCorrect = zeros(1,2);
    f = fitness(pop);
    %numCorrect = (0.1*(f(momind) + f(dadind))/2)*ones(1,2);
else
    indiv = [pop.rules(momind,:);pop.rules(dadind,:)];
    correctSetSize = [pop.correctSetSize(momind) pop.correctSetSize(dadind)];
%     numMatches = [pop.numMatches(momind) pop.numMatches(dadind)];
%     numCorrect = [pop.numCorrect(momind) pop.numCorrect(dadind)];
    numMatches = zeros(1,2);
    numCorrect = zeros(1,2);
end;
n = ones(1,2);
exp = ones(1,2);
action = [pop.action(momind) pop.action(dadind)];

% Mutation
[indiv action] = mutation(indiv,pop.mutationProb); 

% XXX Subsumption is not used in this version
if (pop.doGASubsumption)
    if (subsume(pop.rules(momind),indiv))
    elseif (subsume(pop.rules(dadind),indiv))
    else
        pop = insert(pop,indiv,action,correctSetSize,numMatches,numCorrect,n,exp);
    end;
else
    pop = insert(pop,indiv,action,correctSetSize,numMatches,numCorrect,n,exp);
end;

pop = deleteIfNecessary(pop);

% Function to insert a new rule produced by the GA into the population
% pop = insert(pop,indiv,action,correctSetSize,numMatches,numCorrect,n,exp)
% I/P arguments -
%   pop - population of rules
%   indiv - the individuals condition that needs to be inserted
%   action - the class labels predicted by the conditions
%   correctSetSize - correct set sizes for the new individuals
%   numMatches - number of matches for the individuals
%   numCorrect - number of correct predictions for the rules
%   n - the numerosities for the new individuals
%   exp - the experience of the rules
% O/P arguments -
%   pop - population of rules
function pop = insert(pop,indiv,action,correctSetSize,numMatches,numCorrect,n,exp)
[N D] = size(indiv);
for i = 1:N
    [popN popD] = size(pop.rules);
    ind = intersect(find(sum(pop.rules == repmat(indiv(i,:),popN,1),2) == D), ...
        find(pop.action == action(i)));
    if (~isempty(ind))
        pop.n(ind) = pop.n(ind) + 1;
    else
        pop.rules = [pop.rules; indiv(i,:)];
        pop.action = [pop.action action(i)];
        pop.correctSetSize = [pop.correctSetSize correctSetSize(i)];
        pop.numCorrect = [pop.numCorrect numCorrect(i)];
        pop.numMatches = [pop.numMatches numMatches(i)];
        pop.n = [pop.n n(i)];
        pop.exp = [pop.exp exp(i)];
        pop.lastTimeinGA = [pop.lastTimeinGA 0];
    end;
end;

% Function to select a random individual for crossover/mutation
% index = selOffspring(pop,actionset)
% I/P arguments -
%   pop - population of rules
%   actionset - the actionset, individuals are selected from the actionset
% O/P arguments -
%   index - index of the individual in the population that can be used to
%   introduce new individuals into the population
function index = selOffspring(pop,actionset)
F = fitness(pop);
fitnessSum = sum(F(actionset));
choicePoint = rand(1,1)*fitnessSum;
cumSum = cumsum(F(actionset));
ind = find(cumSum >= choicePoint,1,'first');
index = actionset(ind);

% Not used
function childInd = copy(pop,parentInd)
pop.rules = [pop.rules pop.rule(parentInd)];
pop.action = [pop.action pop.action(parentInd)];
pop.n = [pop.n pop.n(parentInd)];
pop.exp = [pop.exp pop.exp(parentInd)];
pop.numMatches = [pop.numMatches pop.numMatches(parentInd)];
pop.numCorrect = [pop.numCorrect pop.numCorrect(parentInd)];
pop.correctSetSize = [pop.correctSetSize pop.correctSetSize(parentInd)];

childInd = length(pop.rules);
