%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Initialises the empty population before starting to train
% pop = initpop(D)
% I/P argument
%   D - length of the input bit string
% O/P argument
%   pop - the empty population and other parameters required to tune UCS
% One can change the parameters of UCS in this function before the UCS is
% run. Refer to UCS/XCS papers for the description of the parameters.
function pop = initpop(D)
M = 3^D;
pop.rules = [];
pop.n = [];
pop.exp = [];
pop.numMatches = [];% number of matches for each rule
pop.numCorrect = [];% number of correct predictions for each rule
pop.action = [];
pop.correctSetSize = [];
pop.lastTimeinGA = [];
pop.mutationProb = 0.04;% probability of mutation
pop.crossoverProb = 0.8; % probability of applying crossover
pop.coveringProb = 0.33333; % probability of introducing # when covvering
pop.ThetaDel = 20;% deletion threshold
pop.ThetaDelFrac = 0.1;% specifies the fraction of mean fitness for deletion
pop.MAXSIZE = 25*(2^D);
pop.gaThreshold = 25;
pop.v = 10;
pop.inexperienceThresh = 10;
pop.inexperiencePenalty = 0.01;
pop.doGASubsumption = 0;
pop.iter = 0;
pop.beta = 0.2;
