%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Function to compute the fitness of the individuals in a population
% f = fitness(pop)
% I/P arguments -
%   pop - population of rules
% O/P arguments -
%   f - vector of fitness of the individuals
function f = fitness(pop)
acc = zeros(size(pop.rules,1),1);
ind = find(pop.numMatches ~= 0);
acc(ind) = pop.numCorrect(ind)./pop.numMatches(ind);
f = acc.^(pop.v);
ind = find(pop.numMatches < pop.inexperienceThresh);
f(ind) = f(ind)*pop.inexperiencePenalty;
