%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Function to select and delete individuals if the population size exceeds
% the maximum.
% pop = deleteIfNecessary(pop)
% I/P arguments -
%   pop - population of rules
% O/P arguments -
%   pop - population of rules after possible deletion
function pop = deleteIfNecessary(pop)
while sum(pop.n) >= pop.MAXSIZE
    f = fitness(pop);f = f';
    avgFitness = sum(f)/sum(pop.n);
    deletionVote = (pop.correctSetSize).*(pop.n);
    ind = intersect(find(pop.numMatches > pop.ThetaDel),find(f./(pop.n) < pop.ThetaDelFrac*avgFitness));
    if (~ isempty(ind))
        deletionVote(ind) = deletionVote(ind).*(avgFitness./(f(ind)./(pop.n(ind))));
    end;
    cumDelVote = cumsum(deletionVote);
    choicePoint = rand(1,1)*sum(deletionVote);
    ind = find(cumDelVote >= choicePoint,1);
    %disp(sprintf('Deleting %d', length(pop.rules)));
    if (specific(pop.rules(ind)) && (pop.numCorrect(ind) == pop.numMatches(ind)))
        disp('Deleted a specific rule');
    end;
    pop = deletePop(pop,ind);
end;

% Actual deletion happens in this function with ind being the index of the
% individual to be deleted.
function pop = deletePop(pop,ind)
pop.n(ind) = max(pop.n(ind) - 1,0);
indz = find(pop.n == 0);
pop.n(indz) = [];
pop.rules(indz,:) = [];
pop.numCorrect(indz) = [];
pop.numMatches(indz) = [];
pop.action(indz) = [];
pop.correctSetSize(indz) = [];
pop.lastTimeinGA(indz) = [];
