%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.


% Covering function adds a random rule to the population that matches the
% input to avoid a zero size matchset.
% pop = covering(pop,x,cl)
% I/P arguments -
%   pop - population of rules
%   x - input bit string
%   cl - class label
% O/P arguments -
%   pop - population updated with a new rule that matches x
function pop = covering(pop,x,cl)
[N D] = size(x);
k = rand(1,D);
ind = find(k < pop.coveringProb);
% introduces #s in random bits in x
x(ind) = 2;
pop.rules = [pop.rules; x];
pop.n = [pop.n 1];
pop.exp = [pop.exp 0];
pop.action = [pop.action cl];
pop.numMatches = [pop.numMatches 0];
pop.numCorrect = [pop.numCorrect 0];
pop.correctSetSize = [pop.correctSetSize 1];
pop.lastTimeinGA = [pop.lastTimeinGA 0];
pop = deleteIfNecessary(pop);
