%    This file is part of UCS.
%
%    UCS is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    UCS is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with UCS.  If not, see <http://www.gnu.org/licenses/>.

% Function to change from one base to another
% y = changebase(x,base,digits)
% I/P arguments -
%	x - numbers in decimal base
%	base - the base to convert it to, conditions of the rule is represented as ternary base 
%	digits - numbers of digits in the converted string
function y = changebase(x,base,digits)
N = length(x);
l = dec2base(x,base,digits);
y = zeros(N,digits);
for j = 1:digits
    y(:,j) = str2num(l(:,j));
end;
