package ucs;

import java.util.*;

import dataprocessing.Example;

/**
 * Container class for a UCS population. This extends ArrayList, adding some utility methods
 * specific to UCS.
 * @author Gavin Brown
 */
public class Population extends ArrayList
{
	String macros = "";
	
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * Calculates the average accuracy of all individuals in this population.
	 * @return A double providing the average accuracy.
	 */
	public double averageAccuracy()
	{
		double total=0;
		Iterator myIterator = this.iterator();
		while (myIterator.hasNext())
		{
			Indiv ind = (Indiv)myIterator.next();
			total += ind.accuracy; 
		}
		return total/this.size();
	}

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Counts the number of macroclassifiers in this population.
	 * @return An integer count of the number of macroclassifiers.
	 */
	public int numMacroClassifiers()
	{
		boolean print = false;
		
		Iterator myIterator = this.iterator();
		HashSet macroclassifierList = new HashSet();

		HashMap macroFitnesses = new HashMap();
		while (myIterator.hasNext())
		{
			Indiv ind = (Indiv)myIterator.next();
			String x = ind.toString();
			
			
			//collect a statistic to print later
			if( !macroclassifierList.add(x) )
			{
				ArrayList y = (ArrayList)macroFitnesses.get(x);
				//y.add(new Double(ind.fitness()));
				y.add(""+ind.lastTimeThisWasInTheGA);
			}
			else
			{
				ArrayList y = new ArrayList();
				//y.add(new Double(ind.fitness()));
				y.add(""+ind.lastTimeThisWasInTheGA);
				macroFitnesses.put(x, y);
			}
			

		}

		int k=0;
		myIterator = macroclassifierList.iterator();
		macros="";
		while (myIterator.hasNext())
		{
		    //I have no idea why calling toString here causes a runtime error....
		    //Indiv ind = (Indiv)myIterator.next();
		    //String x = ind.toString();
		    //macros += x + "\t" + ind.accuracy + "\t" + ind.numMatches + "\n";
		    String x = (String)myIterator.next();
		    macros += x + "\n";
			/*
			if (print)
			{
				System.out.print((k++)+" : "+x+" - ");
				ArrayList y = (ArrayList)macroFitnesses.get(x);
				Iterator yiter = y.iterator();
				while (yiter.hasNext())
				{
					System.out.print(yiter.next()+",");
				}
				System.out.println();
			}
			*/
		}
		
		
		return macroclassifierList.size();
	}
	
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * Prints out every Individual in this Population.
	 */
	public void print()
	{
		Iterator myIterator = this.iterator();
				
		while (myIterator.hasNext())
		{
			Indiv ind = (Indiv)myIterator.next();
			
			String s = ind.toString()+" , Accuracy: "+ind.accuracy+" , Experience: "+ind.numMatches;

			System.out.println(s);
		}
	}
	
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * Prints out every unique indivual in this Population.
	 */
	public void printMacros()
	{
		System.out.println(macros);
	}
}

