package ucs;

/**
 * The default fitness function for UCS <i>but</i> using GA_v instead of v. 
 * Otherwise as originally used by <i>Bernado et al.</i>,
 * this calculates <i>acc<sup>v</sup></i> then discounts according to experience, as documented in
 * <i>(Brown, Kovacs, Marshall, GECCO 07)</i>.
 * @author Gavin Brown
*/
public class FitFuncIndependentV extends FitnessFunction
{	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	/**
	 * Evaluates an individual, returning the fitness.
	 * @param indiv An individual to calculate fitness for. 
	 */
	public double evaluate( Indiv indiv )
	{	
		indiv.accuracy = indiv.numCorrect/(double)indiv.numMatches;
		if (Double.isNaN(indiv.accuracy)) indiv.accuracy=0;

		double fitness = Math.pow(indiv.accuracy, indiv.params.GA_v);
		//System.out.println("indiv.params.GA_V = " + indiv.params.GA_v);

		/*
		 * THE ORIGINAL IMPLEMENTATION OF UCS USED AN UNDOCUMENTED 
		 * INEXPERIENCE HACK. THIS IS AS CODED BELOW AND DETAILED
		 * IN BROWN, KOVACS, MARSHALL - GECCO 2007
		 * 
		 * if (exp < 10) p_array[m_action] += fitness * 0.01;
		 * else          p_array[m_action] += fitness;
		 */
				
		if(indiv.numMatches < indiv.params.inexperienceThreshold) {
			fitness = fitness * indiv.params.inexperiencePenalty;
		}
			
		return fitness;
	}
	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

}
