package demos;

import ucs.*;
import dataprocessing.*; // for Averager.java

/** 11 multiplexer
 *  
 *  offline learning, with 50/50 train/test splits.
 *  @author Tim Kovacs
 */
public class Margin {

    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    
    static int steps = 50000;
    static int testInterval = steps;
    static double noise = 0.10;
    static int maxReps = 20;

    public static void main( String [] args ) {
	System.out.println("11 multiplexer, 50/50 test-train split, " + maxReps + " replications");

	int[] vSettings = {5,10,20,30,40,50};
	for (int i=0; i<vSettings.length; i++) {
	    System.out.println("v=" + vSettings[i] + ", noise=" + noise + "%");
	    runExperiment(vSettings[i]);
	}
    }

    public static void runExperiment(int v_param) {
	Averager acc = new Averager();
	Averager AUCacc = new Averager();
	Averager margin = new Averager();

	for (int rep=0; rep<maxReps; rep++) {
	    UCSconfig params = new UCSconfig();
	    
	    params.onlinelearning=false;
	    params.v = v_param;
	    params.noise = noise;
	    params.verbosity = 0;
	    
	    params.setProblem("./data/11mux.csv"); //Note: because we didn't specify a testing file it makes a 50:50 random split.		
	    
	    UCS myucs = new UCS(params);
	    
	    //run for xxx steps, with a test phase (and printing stats) at intervals of yyy
	    myucs.run(steps, testInterval);
	    
	    acc.add(myucs.getAccuracy());
	    AUCacc.add(myucs.getAUCAccuracy());
	    margin.add(myucs.getAverageMargin());
	}
	
	System.out.print("AVERAGE");
	
	// Print accuracy on the final test pass (to x decimal places)
	System.out.printf(" Accuracy: %.4f", acc.average());
	System.out.printf(" %.4f", acc.upper95ConfidenceLimit());
	System.out.printf(" %.4f", acc.lower95ConfidenceLimit());
	
	// Print the AUCaccuracy as it was on the final test pass (which is an aggregate over the whole run)
	System.out.printf(" AUCAccuracy: %.4f", AUCacc.average());
	System.out.printf(" %.4f", AUCacc.upper95ConfidenceLimit());
	System.out.printf(" %.4f", AUCacc.lower95ConfidenceLimit());
	
	// Print average margin from the final test phase
	System.out.printf(" Average-margin: %.5f",  margin.average());
	System.out.printf(" %.5f", margin.upper95ConfidenceLimit());
	System.out.printf(" %.5f", margin.lower95ConfidenceLimit());
	System.out.println();
    }
    
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////	
    
}//end class
