package dataprocessing;

import java.util.ArrayList;


/**
 * A single input-output pattern pairing.
 */
public class Example
{
	/** The inputs for this Example.  Values are coded as indices into the <i>inputAlphabet</i> ArrayList,
	 *  with -1 indicating the "don't care" symbol.
	 */
	public double [] inputs;
	
	/** The target for this Example.  Value is coded as an index into the <i>targetAlphabet</i> ArrayList. */
	public double target;
	
	/** The set of legal symbols for each input feature. */
	public static ArrayList [] inputAlphabet = null;
	
	/** The set of legal target symbols. */
	public static ArrayList  targetAlphabet = null;
	
	///////////////////////////////////////////////////////////////
	
	public Example( int numInputs )
	{
		inputs = new double[numInputs];
		target = 0;
	}

	///////////////////////////////////////////////////////////////
	
	public Example( int numInputs, int numOutputs )
	{
		inputs = new double[numInputs];
		target = 0;
	}
	
	///////////////////////////////////////////////////////////////

	/** Prints out the return value of the <i>toString()</i> method. */
	public void print()	{ System.out.println(toString()); }
	
	/** Generate a String representation of this Example. Note this returns Strings coded in the
	 * actual alphabet from in the datafile.
	 * @return A String representation of this object.
	 */
	public String toString()
	{
		String output = "{ ";
		for (int i=0; i<inputs.length; i++)
			output+=Example.inputAlphabet[i].get((int)inputs[i])+"  ";

		output+="}";
		
		output+=" = "+Example.targetAlphabet.get((int)target);
		
		return output;
	}

	///////////////////////////////////////////////////////////////

	/** Test this Example object for equality with another Example. Returns true if the input and target are equal.
	 * @param other An Example object to compare this one to.
	 * @return True if the Examples are equal.
	 */
	public boolean equals( Object other )
	{
		Example e = (Example)other;
		if(e.inputs.equals(this.inputs) && e.target==this.target)
			return true;
		else
			return false;
	}

	///////////////////////////////////////////////////////////////
}
