function visualise_ahha_3d (filename,num_values,main_title,x_label,y_label,z_label,column)

% function visualise_ahha_3d (filename,num_values,main_title,x_label,y_label,z_label,column)

all=load(filename);
z=all(:,1);
x=all(:,2);
y=all(:,3);
X=reshape(x,num_values,num_values,num_values);
Y=reshape(y,num_values,num_values,num_values);
Z=reshape(z,num_values,num_values,num_values);
xmin=min(X(:));
xmax=max(X(:));
xmid=(xmin+xmax)/2;
ymin=min(Y(:));
ymax=max(Y(:));
ymid=(ymin+ymax)/2;
zmin=min(Z(:));
d=all(:,column);
D=reshape(d,num_values,num_values,num_values);
figure;
slice(X,Y,Z,D,[xmin,xmid,xmax],ymax,zmin);
xlabel(x_label);
ylabel(y_label);
zlabel(z_label);
title(main_title);
colorbar;
