package ucs;
import java.util.*;

/**
 *  System Predictor for UCSpv - same as the default predictor except
 *  it does not use vote normalization.
 * @author Gavin Brown
 */
public class UCSpvSysPredictor extends SystemPredictor
{
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	/**
	 * UCSpv system predictor. As introduced by Brown, Kovacs, Marshall GECCO 07.
	 * @param matchSet An arraylist of individuals.
	 * @return The class predicted according to a fitness-weighted vote among the individuals.
	 */
	public int predict( ArrayList matchSet  )
	{
		double [] systemPrediction = new double[Indiv.numOutputs]; //two class problem
		
		Iterator matchSetIterator = matchSet.iterator();
		while (matchSetIterator.hasNext())
		{
			Indiv indiv = (Indiv)matchSetIterator.next();				
		
			systemPrediction[(int)indiv.action] += calcCombinationWeight(indiv);
		}
		
		//SO IT DOESN'T GET NaN ERRORS
		for (int c=0; c<Indiv.numOutputs; c++)
			if (Double.isNaN(systemPrediction[c])) systemPrediction[c]=0;
		
		//CHOOSE THE CLASS WITH MAXIMUM SUPPORT (i.e. largest posterior probability)
		//
		double largestSupport=0;
		int prediction=0;
		for (int c=0; c<systemPrediction.length; c++)
		{			
			if(systemPrediction[c] > largestSupport)
			{
				largestSupport = systemPrediction[c];
				prediction = c;
			}
			//System.out.println(systemPrediction[c] + " for "+Example.targetAlphabet.get(c));
		}
		

		return prediction;
	}
	
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////
	
	/**
	 * Calculates the combination weight for the UCSpv system predictor
	 * @param ind An individual to calculate for.
	 */
	private double calcCombinationWeight( Indiv indiv )
	{
		return indiv.fitness();
	}
	
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////

}
