package ucs;

/** Fitness Function for UCSpv - calculated as in <i>Brown, Kovacs, Marshall GECCO 07</i>.
 * @author Gavin Brown
 */
public class UCSpvFitness extends FitnessFunction
{
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

	/**
	 * UCSpv fitness function, as described in Brown, Kovacs, Marshall GECCO 07
	 * @param indiv An individual to calculate fitness for.
	 */
	public double evaluate( Indiv indiv )
	{
		double fitness = 0;
		
		if (indiv.accuracy==1)
		{
			return 3.45; //alpha' parameter in UCSpv
		}
		else if (indiv.accuracy > 0.5)
		{
			fitness = 0.5*Math.log( (indiv.accuracy)/((1.0-indiv.accuracy)) );
		}

		//note: the inexperience hack is not applied here
		//		if(indiv.numMatches < indiv.params.inexperienceThreshold) {
		//			fitness = fitness * indiv.params.inexperiencePenalty;
		//		}
		
		if (fitness<0) return 0; else return fitness;
	}
	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	
}
