package ucs;

import java.util.*;

import dataprocessing.Example;

/**
 * Ternary tree implementation
 *
 * Adjusted and extended so that it can be integrated into the UCS. Keeps a 
 * uniformity over the methods of Population.java
 * 
 * @author Yiannis Tsentas
 * @version August 2010
 */
public class TTree extends ArrayList
{
    // instance variables - replace the example below with your own
    private Node root;
    private double HASH;
    private double ONE;
    private double ZERO;
	private ArrayList correctSet;
	String macros = "";
	private long SIZE;
	HashMap macroFitnesses = new HashMap();

    /**
     * Constructor for objects of class TTree
     */
    public TTree()
    {
        root = new Node();
        HASH = -1.0;
        ONE = 1.0;
        ZERO = 0.0;
		correctSet = new ArrayList();
		SIZE = 0;
    }

    public void clear() {
        root = null;
		correctSet.clear();
		SIZE = 0;
    }

    public Node getRoot() {
        return root;
    }

	public ArrayList getCorrectSet() {
		return correctSet;
	}
	
	public void clearCorrectSet() {
		correctSet.clear();
	}
    
	/**
	 * Prints out every unique indivual in this Population.
	 */
	public void printMacros()
	{
		System.out.println(macros);
	}
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	
	/*
	 * Add the Indiv in the tree
	 **/
    public void add(Indiv ind)
    {
        Node current = root;
        for (int i=0; i<ind.condition.values.length; i++) {
            if (ind.condition.values[i] == ONE) {
                if (current.getLeft()==null)
                    current.setLeft(new Node());
                current = current.getLeft();
            }
            else if (ind.condition.values[i] == HASH) {
                if (current.getMiddle()==null)
                    current.setMiddle(new Node());
                current = current.getMiddle();
            }
            else {
                if (current.getRight()==null)
                    current.setRight(new Node());
                current = current.getRight();  
            }
        }
		if (current.getValue() == null)	//add if not added already
        	current.setValue(ind);
		else
			current.getValue().numerosity++;
		this.SIZE++;
    }

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
    
    /**
     * Find if the rule exists in the tree
     * 
     * @return  returns true the rule is found and false if it was not
     */    
    public boolean find(double[] input) {
        Node current = root;
        for (int i=0; i<input.length; i++) {
            if (input[i] == ONE) {
                if (current.getLeft() == null)
                    return false;
                current = current.getLeft(); 
            }
            else if (input[i] == HASH) {
                if (current.getMiddle() == null)
                    return false;
                current = current.getMiddle(); 
            }
            else {
                if (current.getRight() == null)
                    return false;
                current = current.getRight(); 
            }
        }
        
        return true;
    }    

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Removes a given rule from the tree
     * code NOT tested
     * 
     * @return  returns true if the removal was successful and false if it wasn't
     */
    public boolean remove(Indiv ind) {
        Node current = root;
        Node previous = null;
        //find
        for (int i=0; i<ind.condition.values.length; i++) {
            if (ind.condition.values[i] == ONE) {
                if (current.getLeft() == null)
                    return false;
                previous = current;
                current = current.getLeft(); 
            }
            else if (ind.condition.values[i] == HASH) {
                if (current.getMiddle() == null)
                    return false;
                previous = current;
                current = current.getMiddle(); 
            }
            else {
                if (current.getRight() == null)
                    return false;
                previous = current;
                current = current.getRight(); 
            }
        }
        //remove
		if (current.getValue().numerosity>1)
			current.getValue().numerosity--;
		else {
        	if (ind.condition.values[ind.condition.values.length-1] == ONE)
            	previous.setLeft(null);
        	else if (ind.condition.values[ind.condition.values.length-1] == HASH)
            	previous.setMiddle(null);
        	else
            	previous.setRight(null);			
		}
		this.SIZE--;
        return true;
    }     
    
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * remove a random rule from the tree
	 **/
	public void removeRandom() {
		Node current = root;
		Node previous = null;
		int random=0;
		
		while (true) {
			ArrayList<Integer> leaf = new ArrayList<Integer>();
			if (current!=null) {			    
			     if (current.getLeft()!=null) leaf.add(0);
			     if (current.getMiddle()!=null) leaf.add(1);
			     if (current.getRight()!=null) leaf.add(2);
			}
			if (leaf.size()==0) break;

			Random rand = new Random();
			random = rand.nextInt(leaf.size());
			random = leaf.get(random);

			previous = current;
			if (random==0)
				current = current.getLeft();
			else if (random==1)
				current = current.getMiddle();
			else
				current = current.getRight();
		}
		
		if (current.getValue().numerosity>1)
			current.getValue().numerosity--;
		else {
			if (random==0)
				previous.setLeft(null);
			else if (random==1)
				previous.setMiddle(null);
			else
				previous.setRight(null);			
		}
		this.SIZE--;					
	}

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
    
    /**
     * Returns the match set (rules that match input) of the given input.
     * It searches through the tree recursively
	 * also computes correctSet
     * 
     * @param   e     Example => input
     * @return  matchSet    return the set of rules that match the input
     */   
	public ArrayList<Indiv> getMatchSet(Example e) { return getMatchSet(this.root, e.inputs, new ArrayList<Indiv>(), e.target); }
    private ArrayList<Indiv> getMatchSet(Node current, double[] input, ArrayList<Indiv> matchSet, double target) {
        Indiv ind = current.getValue();
        if (ind != null) {
                matchSet.add(ind);
				if( ind.test(target) )	correctSet.add(ind);
                return null;
        }
        double c = input[0];
        final int newSize = input.length-1;
        double[] newInput = new double[newSize];
        if (c==ONE){
            Node left = current.getLeft();
            if (left!=null) {
                System.arraycopy(input, 1, newInput, 0, newSize);
                getMatchSet(left, newInput, matchSet, target);
            }
            Node middle = current.getMiddle();
            if (middle!=null) {
                System.arraycopy(input, 1, newInput, 0, newSize);
                getMatchSet(middle, newInput, matchSet, target);
            }
        }
        else {
            Node right = current.getRight();
            if (right!=null) {
                System.arraycopy(input, 1, newInput, 0, newSize);
                getMatchSet(right, newInput, matchSet, target);
            }
            Node middle = current.getMiddle();
            if (middle!=null) {
                System.arraycopy(input, 1, newInput, 0, newSize);
                getMatchSet(middle, newInput, matchSet, target);
            }
        }
        
        return matchSet;
    }   

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////////////// 
	
    /**
     * Returns the the whole population; all the rules in the tree.
     * 
     * @return  values      return the set of rules
     */
	public ArrayList<Indiv> getAll() { return getAll(this.root, new ArrayList<Indiv>()); }
    private ArrayList<Indiv> getAll(Node current, ArrayList<Indiv> values) {
		Indiv ind = current.getValue();
        if (ind != null) {
                values.add(ind);
                return null;
        }
        final Node right = current.getRight();
        if (right!=null)
            getAll(right, values);
        final Node middle = current.getMiddle();
        if (middle!=null)
            getAll(middle, values);
        final Node left = current.getLeft();
        if (left!=null)
            getAll(left, values);
        
        return values;
    }	

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * Calculates the average accuracy of all individuals in this population.
	 * 
	 * @return A double providing the average accuracy.
	 */
	public double averageAccuracy() { return averageAccuracy(this.root, new Double(0)); }
	private double averageAccuracy(Node current, double total)
	{
		Indiv ind = current.getValue();
        if (ind != null) {
                total += ind.accuracy; 
                return 0.0;
        }
		final Node right = current.getRight();
        if (right!=null)
            averageAccuracy(right, total);
        final Node middle = current.getMiddle();
        if (middle!=null)
            averageAccuracy(middle, total);
        final Node left = current.getLeft();
        if (left!=null)
            averageAccuracy(left, total);

		return total/this.SIZE;
	}
	
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
		
	/**
	 * Prints out every Individual in this Population.
	 */
	public void print()	{ print(root, new ArrayList<Indiv>()); }
    private void print(Node current, ArrayList<Indiv> values) {
		Indiv ind = current.getValue();
        if (ind != null) {
                String s = ind.toString()+" , Accuracy: "+ind.accuracy+" , Experience: "+ind.numMatches;
				System.out.println(s);
                return;
        }
        final Node right = current.getRight();
        if (right!=null)
            getAll(right, values);
        final Node middle = current.getMiddle();
        if (middle!=null)
            getAll(middle, values);
        final Node left = current.getLeft();
        if (left!=null)
            getAll(left, values);
    }	

	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * Counts the number of macroclassifiers in this population.
	 * @return An integer count of the number of macroclassifiers.
	 */
	public int numMacroClassifiers()
	{
		boolean print = false;
				
		//macroFitnesses was move to global variable
		
		macroFitnesses.clear();
		HashSet macroclassifierList = getMacroClassifiers(this.root, new HashSet());

		int k=0;
		Iterator myIterator = macroclassifierList.iterator();
		macros="";
		while (myIterator.hasNext())
		{
		    //I have no idea why calling toString here causes a runtime error....
		    //Indiv ind = (Indiv)myIterator.next();
		    //String x = ind.toString();
		    //macros += x + "\t" + ind.accuracy + "\t" + ind.numMatches + "\n";
		    String x = (String)myIterator.next();
		    macros += x + "\n";
			/*
			if (print)
			{
				System.out.print((k++)+" : "+x+" - ");
				ArrayList y = (ArrayList)macroFitnesses.get(x);
				Iterator yiter = y.iterator();
				while (yiter.hasNext())
				{
					System.out.print(yiter.next()+",");
				}
				System.out.println();
			}
			*/
		}
		
		
		return macroclassifierList.size();
	}
	//used by numMacroClassifiers() to go through tree and collect macroclassifiers
    public HashSet getMacroClassifiers(Node current, HashSet macroclassifierList) {
		Indiv ind = current.getValue();
        if (ind != null) {
                String x = ind.toString();
				
				//collect a statistic to print later
				if( !macroclassifierList.add(x) )
				{
					ArrayList y = (ArrayList)macroFitnesses.get(x);
					//y.add(new Double(ind.fitness()));
					y.add(""+ind.lastTimeThisWasInTheGA);
				}
				else
				{
					ArrayList y = new ArrayList();
					//y.add(new Double(ind.fitness()));
					y.add(""+ind.lastTimeThisWasInTheGA);
					macroFitnesses.put(x, y);
				}
                return null;
        }

        final Node right = current.getRight();
        if (right!=null)
            getMacroClassifiers(right, macroclassifierList);
        final Node middle = current.getMiddle();
        if (middle!=null)
            getMacroClassifiers(middle, macroclassifierList);
        final Node left = current.getLeft();
        if (left!=null)
            getMacroClassifiers(left, macroclassifierList);
        
        return macroclassifierList;
    }		
	
}
