package ucs;
import java.util.*;

import dataprocessing.Example;

/**
 * Default system predictor for UCS. As originally used by Bernardo et al.
 * @author Gavin Brown
 */
public class SystemPredictor
{
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

    public double margin;

	/**
	 * Gets a prediction from a matchset.  Note this does not yet support fitness sharing.
	 * @param matchSet An arraylist of individuals.
	 * @return The class predicted according to a normalized, fitness-weighted vote among the individuals.
	 */
        public int predict( ArrayList matchSet, FitnessFunction fitfunc  )
	{		
		double [] systemPrediction = new double[Indiv.numOutputs]; //two class problem
		double normalizingConstant[] = new double[Indiv.numOutputs];
		
		Iterator matchSetIterator = matchSet.iterator();
		while (matchSetIterator.hasNext())
		{
			Indiv ind = (Indiv)matchSetIterator.next();				
			//systemPrediction[(int)ind.action] += ind.fitness();
			systemPrediction[(int)ind.action] += fitfunc.evaluate(ind);
			
			normalizingConstant[(int)ind.action] += ind.numerosity;
		}
		
		double largestSupport=0;
		double nextLargest=0;
		int prediction=0;
		
		// find the prediction, largest and next largest support
		for (int c=0; c<systemPrediction.length; c++)
		{
			if(normalizingConstant[c]==0) normalizingConstant[c]=1;
			systemPrediction[c] /= (double)normalizingConstant[c];
			if (Double.isNaN(systemPrediction[c])) systemPrediction[c]=0;
			
			if(systemPrediction[c] > largestSupport){
			        nextLargest = largestSupport;
				largestSupport = systemPrediction[c];
				prediction = c;
			}
			else if(systemPrediction[c] > nextLargest)
			    nextLargest = systemPrediction[c];
			
			//System.out.println(systemPrediction[c] + " for "+Example.targetAlphabet.get(c));
		}

		//RECORD THE VOTING MARGIN
		// first make supports sum to one -- FIX - this may not be correct for more than 2 actions
		largestSupport /= (largestSupport + nextLargest);
		nextLargest /= (largestSupport + nextLargest);
		margin = largestSupport - nextLargest;

		//System.out.println("largestSupport " + largestSupport + "

		if (Double.isNaN(margin)) {
		    System.out.println("systemPrediction.length=" + systemPrediction.length);
		    for (int c=0; c<systemPrediction.length; c++) {
			System.out.println("prediction for " + c + "=" + systemPrediction[c]);
		    }
		    System.out.println("matchSet.size() = " + matchSet.size());
		    System.out.println("matchSet[0] = " + matchSet.get(0));
		    Indiv ind = (Indiv) matchSet.get(0);
		    System.out.println("matchSet[0].accuracy = " + ind.accuracy);
		    System.out.println("matchSet[0].numMatches = " + ind.numMatches);
		    System.out.println("matchSet[0].numCorrect = " + ind.numCorrect);

		    // code sometimes reaches this point. I've seen match sets with 1 or 2 rules.
		    // predictions for both classes is 0.0. I don't know how this is possible as all
		    // rules start life with numMatches = 1 and numCorrect = 1 which gives a non-zero accuracy
		    // and hence non-zero prediction. accuracy is also initialised to 1
		    // See Indiv.clone() for initialisation of rules by GA and UCS.covering() for init by covering
		    // And yet there's a rule with accuracy 0. A test at the start of Indiv.matches()
		    // reveals rules with numCorrect == 0 (or any int you initialise it to at the top of that file).
		    // The same when testing for accuracy == 0. This shows
		    // there are rules being generated other than by clone() and covering() although
		    // I can't find this with grep. Also accuracy is set to 1 in the accuracy constructor so its
		    // not being used (or accuracy is being reset). 
		    // I added a field 'magic' to Indiv and it is getting set by the constructor so the other
		    // stuff must be reset somewhere...
		    // numMatches can be 0 in matches so rules must be initialised somewhere other than clone
		    // and covering. <- they;re also made in crossAndMutate()

		    throw new IllegalStateException("margin is NaN in SystemPredictor.predict()" +
						    " largestSupport=" + largestSupport + " nextLargest= " + nextLargest);
		}
		

		//debugging
		//System.out.println("largestSupport = " + largestSupport);
		//System.out.println("nextLargest = " + nextLargest);
		//System.out.println("margin = " + margin);
		
		//CHOOSE THE CLASS WITH MAXIMUM SUPPORT
		//if(systemPrediction[0] > systemPrediction[1]) return 0; else return 1;
		return prediction;
	}
	
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////////

}
