package ucs;
/**
 * Node to be used for the ternary tree.
 * Keeps a value and pointers to three other nodes (ternary tree)
 * 
 * @author Yiannis Tsentas
 * @version August 2010
 */
public class Node
{
    // instance variables - replace the example below with your own
    private Indiv ind;
    private Node left;
    private Node middle;
    private Node right;

    /**
     * Constructor for objects of class Node
     */
    public Node()
    {
        ind = null;
        left = null;
        middle = null;
        right = null;
    }

    public void clear() {
        ind = null;
        left = null;
        middle = null;
        right = null;        
    }    
    
    public Indiv getValue() {
        return ind;    
    }
    public Node getLeft() {
        return left;
    }   
    public Node getMiddle() {
        return middle;
    }   
    public Node getRight() {
        return right;
    }    
    public void setValue(Indiv v) {
        ind = v ;   
    }
    public void setLeft(Node l) {
        left = l;
    }   
    public void setMiddle(Node m) {
        middle = m;
    }   
    public void setRight(Node r) {
        right = r;
    }       
}
