#!/usr/bin/perl -w

## avg.pl
#
# Averages over (possibly prefixed) values from n runs in columns
#
# Author: Rob Egginton
# Email:  egginton@cs.bris.ac.uk
# Date:   22/11/2006
# Bug which prevented averaging of real numbers fixed 21/1/2010 
##

use strict;

my ( $command, $repeats, $prefix, @values );
my $usage = "Usage: $0 command repeats [ line_prefix ]\n";

## Get command line arguments
#  Read: 1. Shell command
#        2. Number of runs
#       (3. optional) prefix for lines

if ( !exists $ARGV[0] || $ARGV[0] eq '' ) {
    die( $usage );
}
$command = $ARGV[0];
if ( !exists $ARGV[1] || $ARGV[1] eq '' ) {
    die( $usage );
}
$repeats = $ARGV[1] + 0;
if ( exists $ARGV[2] && $ARGV[2] ne '' ) {
    $prefix = $ARGV[2];
}

## Call command $repeat times

for ( my $iter=0; $iter < $repeats; $iter++ ) {
    print STDERR "\nIter $iter : $command\n";
    open(ARTICLE, '-|', $command)
	or die "Can't start $command: $!";
    # Get input 
    my $lineNum = 0;
    while(<ARTICLE>) {
	print STDERR $_;
	my @cols = ();
	if ( (defined $prefix && s/^$prefix//) || !defined $prefix ) {
	@cols = /(-?[\d\.]+)[^\d\.]/g;
	}
	if ( $#cols > 0 ) {
	    push @{$values[$lineNum]}, [@cols];
	    $lineNum++;
	}
    }
    close( ARTICLE );
}

print STDERR "\n AVERAGING...\n\n";

# Output averages

my $lineNum = 0;
foreach my $line ( @values ) {
  my @sum = ();
  my @valCnt = ();
  # Set sums to 0
  for ( my $col=0; $col<=$#{$$line[0]}; $col++ ) {
      $sum[$col] = 0;
      $valCnt[$col] = 0;
  }
  # Add to sums
  for ( my $fle=0; $fle<=$#$line; $fle++ ) {
      my $cols = $$line[$fle];
      for ( my $cl=0; $cl<=$#$cols; $cl++ ) {
	  $sum[$cl] += $$cols[$cl];
	  $valCnt[$cl]++;
      }
  }
  # Average
  for ( my $c=0; $c<=$#{$$line[0]}; $c++ ) {
      if ( $valCnt[$c] > 0 ) {
	  $sum[$c] = $sum[$c] / ($valCnt[$c]*1.0);
      }
  }
  print STDOUT "$lineNum ";
  foreach my $sm ( @sum ) {
      print STDOUT "$sm ";
  }
  print STDOUT "\n";
  $lineNum++;
}
