package demos;

import ucs.*;

/** UCSpv demo doing online learning on the 11mux problem.
 *  @author Gavin Brown
 */
public class MuxDemo {

	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////

	public static void main( String [] args )
	{
		UCSconfig params = new UCSconfig();
		
		params.setFitnessFunction(new UCSpvFitness() );
		params.setSystemPredictor(new UCSpvSysPredictor() );
		params.setProblem("./data/11mux.csv");

		UCS myucs = new UCS(params);
		
		myucs.run(10000, 2500);
		myucs.params.mutationProb = 0;
		
		myucs.run(10000, 2500);
		myucs.pop.printMacros();
		
		//the optimal multiplexer with 16 rules should be discovered
		// but only if mutation is turned off after a while
	}

	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////	

}//end class
