package demos;

import ucs.*;
import dataprocessing.*; // for Averager.java

/** This uses different values of v for the GA and for prediction.
 *  
 *  @author Tim Kovacs
 *
 * To run online experiments set params.verbosity to > 0 which will print
 * the results of each test phase. If you only want end-of-run stats
 * then set verbosity to 0.
 * 
 * This UCS cannot learn the 6mux with 50/50 split past about 80% accuracy
 * even with 6400 rules. However it can learn the 11mux with 50/50 split to
 * 100% accuracy.
 * Nara's matlab UCS gets 90% (and possibly still rising) on the 6mux
 * with 75/25 split.
 */
public class IndependentV {

    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    
    static int steps = 50000;
    static int testInterval = 1000;
    static double noise = 0.0;
    static int maxReps = 1;
    static String dataFile = "./data/6parity.csv";
    static UCSconfig params;

    public static void main( String [] args ) {
	System.out.println("# demos/IndenpendentV.java " + dataFile + " with " + maxReps 
			   + " replications " + steps + " steps " + testInterval + " testInterval");

	params = makeConfig();
	params.print("# ");

	//To run a single experiment
	//runExperiment(10, 10);

	//To run multiple experiments
	constantV();
	//constantGA_v();

	//To run a series with v=GA_v
	//joint_v();
    }

    public static void constantV() {
	int[] vSettings    = {20,20,20,20,20,20,20};
	int[] GA_vSettings = {1,5,10,20,30,40,50};
	for (int i=0; i<vSettings.length; i++) {
	    System.out.println("v=" + vSettings[i]  + ", GA_v = " + GA_vSettings[i] + ", noise=" + noise + "%");
	    runExperiment(vSettings[i], GA_vSettings[i]);
	}
    }
    
    public static void constantGA_v() {
	int[] vSettings    =  {1,5,10,20,30,40,50};
        int[] GA_vSettings = {10,10,10,10,10,10,10};
	for (int i=0; i<GA_vSettings.length; i++) {
	    System.out.println("v=" + vSettings[i]  + ", GA_v = " + GA_vSettings[i] + ", noise=" + noise + "%");
	    runExperiment(vSettings[i], GA_vSettings[i]);
	}
    }

    public static void joint_v() {
	int[] joint    =  {1,5,10,20,30,40,50};
	for (int i=0; i<joint.length; i++) {
	    System.out.println("v=" + joint[i]  + ", GA_v = " + joint[i] + ", noise=" + noise + "%");
	    runExperiment(joint[i], joint[i]);
	}
    }

    /** Return a UCSconfig with all settings for the experiment(s) except those which vary across
     * experiments: v, GA_v, noise */
    public static UCSconfig makeConfig() {
	params = new UCSconfig();
	
	params.GAfitfunc = new FitFuncIndependentV();	
	params.POPMAXSIZE=25*64;
	params.onlinelearning=true;
	params.verbosity=0; // >= 0 means show result of each test set

	return params;
    };
    
    public static void runExperiment(int v_param, int GA_v_param) {
	Averager acc = new Averager();
	Averager AUCacc = new Averager();
	Averager margin = new Averager();

	for (int rep=0; rep<maxReps; rep++) {
	    // set parameters which may vary across experiments
	    params.v = v_param;
	    params.GA_v = GA_v_param;
	    params.noise = noise;	    

	    // (re)load the data
	    params.setProblem(dataFile); 	    	   

	    UCS myucs = new UCS(params);

	    //run for xxx steps, with a test phase (and printing stats) at intervals of yyy
	    myucs.run(steps, testInterval);
	    
	    acc.add(myucs.getAccuracy());
	    AUCacc.add(myucs.getAUCAccuracy());
	    margin.add(myucs.getAverageMargin());
	}
	
	System.out.print("AVERAGE");
	
	// Print accuracy on the final test pass (to x decimal places)
	System.out.printf(" Accuracy: %.4f", acc.average());
	System.out.printf(" %.8f", acc.upper95ConfidenceLimit());
	System.out.printf(" %.8f", acc.lower95ConfidenceLimit());
	
	// Print the AUCaccuracy as it was on the final test pass (which is an aggregate over the whole run)
	System.out.printf(" AUCAccuracy: %.4f", AUCacc.average());
	System.out.printf(" %.4f", AUCacc.upper95ConfidenceLimit());
	System.out.printf(" %.4f", AUCacc.lower95ConfidenceLimit());
	
	// Print average margin from the final test phase
	System.out.printf(" Average-margin: %.5f",  margin.average());
	System.out.printf(" %.5f", margin.upper95ConfidenceLimit());
	System.out.printf(" %.5f", margin.lower95ConfidenceLimit());
	System.out.println();	
    }
    
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////	
    
}//end class
