package demos;

import ucs.*;

/** A demo using n-fold cross-validation.
 *  @author Gavin Brown and Tim Kovacs
 *
 *  This demo generates train and test using cross-validation. The number 
 *  of folds must be 2 or more. (With 1 fold all the data ends up in the test set and there's none in
 *  the train set.) So you cannot set folds to 1 here and have it work.
 *  <p>
 *  If instead of n-fold cross-validation you want to split the data
 *  into train and test sets by percentage use the approach in BasicUCS.java
 *  <p>
 *  Note that onlinelearning must be false as it indicates that all data
 *  is used for both the train and test sets.
 */

public class CrossValidateDemo1 {

	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
		
        public static void main( String [] args )
        {
	    UCSconfig params = new UCSconfig();
	    params.onlinelearning=false;
	    params.setProblem("./data/foldme-big.csv");
	    params.folds = 5;
            System.out.println("Using " + params.folds + " folds");

	    double tot=0;
	    for (int fold=0; fold<params.folds; fold++)
	    {
		UCS myucs = new UCS(params);

		//run for 20000, printing at intervals of 500
		myucs.run(20000, 500);
		
		tot = tot +  myucs.getAUCAccuracy();
	    }

	    System.out.println("Average AUCAccuracy over runs: " + tot/params.folds);
	}
}
