% Dima Damen
% Created: September 21st 2007

% This function transforms an image using a certain transformation

% Input: bwDiff - the image to be back-transformed
%        TA - the translation of the transformation [TX, TY]
%        RA - the rotation of the transformation (an angle in 180 scale)
%        SA - the scale of the translation (0-1)

% Output: transformedBwDiff - the transformed image

function transformedBwDiff = tranformImage (bwDiff, TA, RA, SA, params)

   % parameters
   personWidth = params.Results.personWidth;
   personHeight = params.Results.personHeight;

   % translating the image back
   TX = TA (1,1);
   TY = TA (2,1);
   
%    figure; imshow (bwDiff);
   % rotating the image back
   bwDiffTranslated = circshift (bwDiff, [TX, TY]);
%    figure; imshow (bwDiffTranslated);
   bwDiffRotated = imrotate (bwDiffTranslated, RA, 'bilinear');
%    figure; imshow (bwDiffRotated);
   
   % resizing the image back
   bwDiffResize = imresize (bwDiffRotated, SA);
%    figure; imshow (bwDiffResize);
   
   % ensuring the image has the required size
   [tt, uu] = size (bwDiffResize);
   hDiff = (tt - personHeight)/2;
   if (hDiff < 1)
     hDiff = 1;
   end;
   wDiff = (uu - personWidth)/2;
   if (wDiff < 1)
      wDiff = 1;
   end;
   transformedBwDiff = imcrop (bwDiffResize, [wDiff, hDiff, personWidth-1, personHeight-1]);
   transformedBwDiff = centerImage (transformedBwDiff, personHeight, personWidth);
end