function [pBagProb, pNoBagProb] =  multiplyPersonDiffWithPriors (beginningFileName, diff, direction, personTransformations, startTemplate, params)
         
     writeIntermediateResults = params.Results.writeIntermediateResults;

     switch (direction)
       case 1
           bagModel = imread (strcat (startTemplate, 'Model1_5.jpg'));
       case 2
           bagModel = imread (strcat (startTemplate, 'Model2_6.jpg'));
       case 3
           bagModel = imread (strcat (startTemplate, 'Model3_7.jpg'));
       case 4
           bagModel = imread (strcat (startTemplate, 'Model4_8.jpg'));
       case 5
           bagModel = imread (strcat (startTemplate, 'Model1_5.jpg'));
           bagModel = flipdim (bagModel, 2);
       case 6
           bagModel = imread (strcat (startTemplate, 'Model2_6.jpg'));
           bagModel = flipdim (bagModel, 2);
       case 7
           bagModel = imread (strcat (startTemplate, 'Model3_7.jpg'));
           bagModel = flipdim (bagModel, 2);
       case 8
           bagModel = imread (strcat(startTemplate, 'Model4_8.jpg'));
           bagModel = flipdim (bagModel, 2);
      end;
      bagModel = double (bagModel)/255;

      TA = personTransformations (1,1:2)';
      RA = personTransformations (1,3);
      SA = personTransformations (1,4);
      
      transformedBagModel = tranformImage (bagModel, TA, RA, SA, params);
      scaledTransformedBagModel = transformedBagModel + 0.5;
      NoScaledTransformedBagModel = 1 - scaledTransformedBagModel;
      
        
      % Now we need to figure out what to do with the d value from diff!
      pBag = (0.3557* normpdf (diff, 1, 0.05) + 0.6443* normpdf (diff, 0.6, 0.3)) ./ 0.7504;
      
%       pNoise = exp (-10*diff) ./ 0.1005;
%       pNoise = exp (-10*diff) ./ 0.1;
      pNoise = (1 ./ (diff + 0.01)) / 4.62;
      if (writeIntermediateResults == true)
          imwrite (pBag, strcat (beginningFileName, 'diffBagV2_TS.jpg'));
          imwrite (scaledTransformedBagModel, strcat (beginningFileName, 'diffBagPrior.jpg'));
          imwrite (pNoise, strcat (beginningFileName, 'diffNoiseV2_TS.jpg'));
          imwrite (NoScaledTransformedBagModel, strcat (beginningFileName, 'diffNoisePrior.jpg'));
      end;
      
      % just normalize to see what exactly is happening there!!
%       pBagN = pBag ./ (pBag + pNoise);
%       imwrite (pBagN, strcat (beginningFileName, 'difflikelihoodV.jpg'));      

      % with probability with and without normalization
      pBagProb = scaledTransformedBagModel .* pBag;
      pNoBagProb = NoScaledTransformedBagModel .* pNoise;
      if (writeIntermediateResults == true)
          imwrite (pBagProb, strcat (beginningFileName, 'diffWithPriorBag2.jpg'));
          imwrite (pNoBagProb, strcat (beginningFileName, 'diffWithPriorNoise2.jpg'));
      end;
end