function p = loadParameters ()
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% loadParameters ()
% Syntax:
%   p = loadParameters()
%
% Descrioption:
%   returns an input parser with the default values for all the parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   p = inputParser;
   p.addParamValue ('personHeight', 240); %240
   p.addParamValue ('personWidth', 160); % set to 2 thirds of the height 160
   p.addParamValue ('minHeight', 100);
   
   p.addParamValue ('minNoOfFrames', 10);
   p.addParamValue ('maxNoOfFrame', 50);
   p.addParamValue ('split', false);
   
   p.addParamValue ('topValue', 80);

   p.addParamValue ('homography', 'Hom\bagsData.dat', @ischar);
   p.addParamValue ('verticalLines', 'Hom\verticalLines.csv', @ischar);
   p.addParamValue ('useFoot', false);
   
   p.addParamValue ('minR', -15);
   p.addParamValue ('maxR', 15);
   p.addParamValue ('RJump', 5);
   p.addParamValue ('minS', 0.2);
   p.addParamValue ('maxS', 0.8);
   p.addParamValue ('SJump', 0.05);
   
   p.addParamValue ('PRange', 2.8);
   p.addParamValue ('median', false);
   p.addParamValue ('imgtype', 'jpg');

   p.addParamValue ('backgroundColour', 0);
   
   p.addParamValue ('writeIntermediateResults', false);
end