function rescale = decideRescaleFactor (bbFile, params)

   personHeight = params.Results.personHeight;
   personWidth  = params.Results.personWidth;

   Heights = bbFile(:,5) - bbFile(:,3);
   Widths = bbFile (:,4) - bbFile(:,2);
   chosenHeight = prctile (Heights, 75) + 15;
   chosenWidth = prctile (Widths, 75) + 10;
   
   rescale = min (min (personHeight/chosenHeight, 1), min (personWidth/chosenWidth, 1));
   
end