% Created by: Dima Al Damen
% November 23rd

% This model tries to generate the graph cuts based on the new calcultions
% of bags. This is done by reading the values resulting from multiplying
% bags by priors, and no bags by 1-prior. The parametric models explaining
% where these came from could be retrieved from multiplyDiffWithPrior2

function [bags] = analyzePersonWithTemplatePrior6 (beginningFileName, bagLabelModel, noiseLabelModel, personTemplate, P, params) % , bagMinimumFramesPercentage, minimumBagSize)

   % global MRFFolder;
    writeIntermediateResults = params.Results.writeIntermediateResults;
    
    SmoothnessCost = [[0, P]; [P, 0]];
      
   DataCost(:,:,1) = bagLabelModel;
   DataCost(:,:,2) = noiseLabelModel;
   
   [gch] = GraphCut('open', DataCost, SmoothnessCost);
   [gch labels] = GraphCut('expand', gch);
   [gch labels] = GraphCut('get', gch);
   labels1 = double(labels)*255;
   [L,num] = bwlabel(labels1);
   graindata = regionprops(L,'all');
   [gch] = GraphCut('close', gch);
   markedImg=LabelBagLocations (personTemplate, labels);
   
   if (writeIntermediateResults == true)
      imwrite (labels1, strcat (beginningFileName, 'graphCutBags_NewTerms.jpg'));
   end;
   
   imwrite (markedImg, strcat (beginningFileName, 'labeledGCTemplatesNewTerms.jpg'));

   bags = zeros (0, 7);
   for i = 1: num
       bagData = [graindata(i).BoundingBox, graindata(i).Centroid, graindata(i).Area];
       bags = [bags; bagData];
   end

end