% Dima Damen
% October 26th 2007

function markedImg=LabelBagLocations (personTemplate, blobImage)

    minArea = 20;
    boundaryWidth = 2;
    markedImg (:,:,1) = personTemplate;
    markedImg (:,:,2) = personTemplate;
    markedImg (:,:,3) = personTemplate;
    
    [L,num] = bwlabel(blobImage);
    graindata = regionprops(L,'basic');
    for i = 1: num
       if (graindata(i).Area < minArea)
           continue;
       end;
       BB = round(graindata(i).BoundingBox);
       x1 = BB(1);
       y1 = BB(2);
       x2 = x1 + BB(3);
       y2 = y1 + BB(4);
       markedImg (y1:(y1+boundaryWidth), x1:x2, 1) = 1;
       markedImg (y1:(y1+boundaryWidth), x1:x2, 2) = 1;
       markedImg (y1:(y1+boundaryWidth), x1:x2, 3) = 0;
       markedImg (y1:y2, x1:(x1+boundaryWidth), 1) = 1;
       markedImg (y1:y2, x1:(x1+boundaryWidth), 2) = 1;
       markedImg (y1:y2, x1:(x1+boundaryWidth), 3) = 0;
       markedImg (y1:y2, x2:(x2+boundaryWidth), 1) = 1;
       markedImg (y1:y2, x2:(x2+boundaryWidth), 2) = 1;
       markedImg (y1:y2, x2:(x2+boundaryWidth), 3) = 0;
       markedImg (y2:(y2+boundaryWidth), x1:x2, 1) = 1;
       markedImg (y2:(y2+boundaryWidth), x1:x2, 2) = 1;
       markedImg (y2:(y2+boundaryWidth), x1:x2, 3) = 0;
    end  
end