# bash script for installing Bristol Multi-Object Detector
set -x #echo on

BASEDIR=`pwd`
echo "Script location: ${BASEDIR}"

# Part I: Setting Up the Workspace
source /opt/ros/fuerte/setup.bash
mkdir -p $1
rosws init $1 /opt/ros/fuerte
source $1/setup.bash

# Part II: Installing USB Camera Drivers
rosws set usb_cam --svn http://svn.code.sf.net/p/bosch-ros-pkg/code/tags/stacks/bosch_drivers/bosch_drivers-0.4.2
source $1/setup.bash
rosws update usb_cam
cp $BASEDIR/usb_cam_patch.patch $1
cd $1
patch -p0 <usb_cam_patch.patch
rosmake usb_cam

# Part III: Install Dependencies
# Bug fixed, install further dependencies to avoid bugs with interface running
sudo apt-get install libglu-dev
sudo apt-get install mesa-utils libgl1-mesa-glx:i386 virtualgl-libs:i386
sudo apt-get -f install freeglut3-dev
#sudo apt-get install libx11-dev
#sudo apt-get install libxi-dev
sudo apt-get install libqt4-core libqt4-gui libqt4-dev
sudo apt-get install liblapack
sudo apt-get install lapack_lite
sudo apt-get install liblapack-dev
sudo apt-get install libblas-dev
sudo apt-get install libblas3gf liblapack3gf

mkdir -p $1/git_temp
set -e
git clone $BASEDIR/vision_libcvd.bundle $1/git_temp/vision_libcvd.git
set +e
cd $1/git_temp/vision_libcvd.git
git checkout master
cd $1
source $1/setup.bash
set -e
rosws set vision_libcvd --git file://$1/git_temp/vision_libcvd.git
set +e
source $1/setup.bash
rosws update vision_libcvd
set -e
rosmake vision_libcvd

#sudo apt-get install libglew-dev


# Part IV: Install and compile the detector
git clone $BASEDIR/mod.bundle $1/git_temp/mod.git
set +e
cd $1/git_temp/mod.git
git checkout master
cd $1
source $1/setup.bash
set -e
rosws set mod --git file://$1/git_temp/mod.git
set +e
source $1/setup.bash
rosws update mod
set -e
rosmake mod
set +e

