function [shiftVector, newMedian] = recentralizeTemplate2 (beginningFileName, img, params)

  personHeight = params.Results.personHeight;
  personWidth = params.Results.personWidth;
  writeIntermediateResults = params.Results.writeIntermediateResults;
  
  newMedian = zeros (personHeight, personWidth);
  
  if (writeIntermediateResults == true)
      imwrite (img, strcat (beginningFileName, '_personTemplate_old.jpg'));
  end;
%  figure; imshow (img);
  imBW = im2bw (img, 0.4);
%  figure; imshow (imBW);
  [m,n] = find (imBW);
  shiftVector = [0 0];
  if (size (m,1) == 0)
      return;
  end;
  medianX = round((max (n) - min (n))/2) + min (n);
  medianY = round((max (m) - min (m))/2) + min (m);
  shiftVector = [(personHeight/2)-medianY (personWidth/2)-medianX];
  newMedian = circshift (img, shiftVector);
  if (writeIntermediateResults == true)
    imwrite (newMedian, strcat (beginningFileName, '_personTemplate.jpg'));
  end;
end