% Created by: Dima Al Damen
% July 2007

% WARNINGS: only works for enlarging now

% This functions centres an image that is smaller than h and w within a
% larger canvas size

% input: img - the input image
%        h - new height - has to be larger or equal to the image's height
%        w - new width - has to be larger or equal to the image's width

% output: centredImg - the new centred image

% uses functions: -

function centredImg = centerImage (img, h, w)
   [oldh, oldw] = size (img);
   if (oldh == h && oldw == w)
       centredImg = img;
       return;
   end;
   hDiff = h - oldh;
   wDiff = w - oldw;
   leftDiff = ceil (wDiff/2);
   if (leftDiff <= 0)
       leftDiff = 1;
   end;
   rightDiff = ceil (wDiff/2);
   topDiff = ceil (hDiff/2);
   if (topDiff <= 0)
       topDiff = 1;
   end
   bottomDiff = ceil (hDiff/2);
   centredImg (topDiff:topDiff+oldh-1, leftDiff: leftDiff+oldw-1) = img;
   centredImg (h-bottomDiff: h, w-rightDiff:w) = 0;
end