% Created by: Dima Al Damen
% July 26th 2007
% Last modified August 23rd 2007

% This function is responsible for matching the person to the template and
% deciding which template and analyzing whether the end
% result contains a bag or not!

% inputs: beginningFileName: the starting string of the images
%         beginningFrame: the starting frame number
%         endFrame: the ending frame number
%         imgtype: if the images are bmp, it transfers it to jpg

% outputs: - bags: The location and bounding boxes of any bags found. A bag
% is identified as an area larger than the minimumBagSize that doesn't
% cancel with the template and remains of a frequency higher than a
% particular threshold within the pertruding foreground pixels.

% uses functions: - getNormalizedPersonTemplate
%                 - getPersonWalkingDirection
%                 - findBestTransformationMatch

% TO BE DELETED

function [direction, trans, diff] = analyzePersonWithTemplate_f (beginningFileName, normalizedTemplate, newMedianFile, params, H, cameraX, cameraY, rescaleFactor, footLoc)

    writeIntermediateResults = params.Results.writeIntermediateResults;
    
    % scale by max
    if (max(max(normalizedTemplate)) > 0)
        normalizedTemplate = normalizedTemplate / max(max(normalizedTemplate));
    end;
    
    %selecting which template
    direction = getPersonWalkingDirection4 (newMedianFile, H, cameraX, cameraY, rescaleFactor, footLoc, params);
    [TA, RA, SA, diff] = findBestTransformationMatchConv_f (beginningFileName, direction, normalizedTemplate, params);    
    %[TA, RA, SA, diff] = findBestTransformationMatchConv_gradientDescent(beginningFileName, direction, normalizedTemplate);
    trans = [TA(1,1), TA(2,1), RA, SA];
    
    r = find (diff(:,:) < 0);
    diff (r) = 0;
    
    if (writeIntermediateResults == true)
       imwrite (diff, strcat (beginningFileName, 'diff.jpg'));
    end;
end