/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.GUIEvent;
import java.awt.Toolkit;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class IFTextField
extends GUIComponent {
    private String contents = "";
    private int cursorPos = 0;
    private int visiblePortionStart = 0;
    private int visiblePortionEnd = 0;
    private int startSelect = -1;
    private int endSelect = -1;
    private float cursorXPos = 0.0f;
    private float startSelectXPos = 0.0f;
    private float endSelectXPos = 0.0f;

    public IFTextField(String string, int n, int n2) {
        this(string, n, n2, 100, "");
    }

    public IFTextField(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, "");
    }

    public IFTextField(String string, int n, int n2, int n3, String string2) {
        this.setLabel(string);
        this.setPosition(n, n2);
        this.setSize(n3, 21);
        this.setValue(string2);
    }

    public static boolean validUnicode(char c) {
        char c2 = c;
        return c2 >= ' ' && c2 <= '~' || c2 >= '\u00a1' && c2 <= '\u017f' || c2 == '\u018f' || c2 == '\u0192' || c2 >= '\u01a0' && c2 <= '\u01a1' || c2 >= '\u01af' && c2 <= '\u01b0' || c2 >= '\u01d0' && c2 <= '\u01dc' || c2 >= '\u01fa' && c2 <= '\u01ff' || c2 >= '\u0218' && c2 <= '\u021b' || c2 >= '\u0250' && c2 <= '\u02a8' || c2 >= '\u02b0' && c2 <= '\u02e9' || c2 >= '\u0300' && c2 <= '\u0345' || c2 >= '\u0374' && c2 <= '\u0375' || c2 == '\u037a' || c2 == '\u037e' || c2 >= '\u0384' && c2 <= '\u038a' || c2 >= '\u038e' && c2 <= '\u03a1' || c2 >= '\u03a3' && c2 <= '\u03ce' || c2 >= '\u03d0' && c2 <= '\u03d6' || c2 >= '\u03da' || c2 >= '\u03dc' || c2 >= '\u03de' || c2 >= '\u03e0' || c2 >= '\u03e2' && c2 <= '\u03f3' || c2 >= '\u0401' && c2 <= '\u044f' || c2 >= '\u0451' && c2 <= '\u045c' || c2 >= '\u045e' && c2 <= '\u0486' || c2 >= '\u0490' && c2 <= '\u04c4' || c2 >= '\u04c7' && c2 <= '\u04c9' || c2 >= '\u04cb' && c2 <= '\u04cc' || c2 >= '\u04d0' && c2 <= '\u04eb' || c2 >= '\u04ee' && c2 <= '\u04f5' || c2 >= '\u04f8' && c2 <= '\u04f9' || c2 >= '\u0591' && c2 <= '\u05a1' || c2 >= '\u05a3' && c2 <= '\u05c4' || c2 >= '\u05d0' && c2 <= '\u05ea' || c2 >= '\u05f0' && c2 <= '\u05f4' || c2 >= '\u060c' || c2 >= '\u061b' || c2 >= '\u061f' || c2 >= '\u0621' && c2 <= '\u063a' || c2 >= '\u0640' && c2 <= '\u0655' || c2 >= '\u0660' && c2 <= '\u06ee' || c2 >= '\u06f0' && c2 <= '\u06fe' || c2 >= '\u0901' && c2 <= '\u0939' || c2 >= '\u093c' && c2 <= '\u094d' || c2 >= '\u0950' && c2 <= '\u0954' || c2 >= '\u0958' && c2 <= '\u0970' || c2 >= '\u0e01' && c2 <= '\u0e3a' || c2 >= '\u1e80' && c2 <= '\u1e85' || c2 >= '\u1ea0' && c2 <= '\u1ef9' || c2 >= '\u2000' && c2 <= '\u202e' || c2 >= '\u2030' && c2 <= '\u2046' || c2 == '\u2070' || c2 >= '\u2074' && c2 <= '\u208e' || c2 == '\u2091' || c2 >= '\u20a0' && c2 <= '\u20ac' || c2 >= '\u2100' && c2 <= '\u2138' || c2 >= '\u2153' && c2 <= '\u2182' || c2 >= '\u2190' && c2 <= '\u21ea' || c2 >= '\u2190' && c2 <= '\u21ea' || c2 >= '\u2000' && c2 <= '\u22f1' || c2 == '\u2302' || c2 >= '\u2320' && c2 <= '\u2321' || c2 >= '\u2460' && c2 <= '\u2469' || c2 == '\u2500' || c2 == '\u2502' || c2 == '\u250c' || c2 == '\u2510' || c2 == '\u2514' || c2 == '\u2518' || c2 == '\u251c' || c2 == '\u2524' || c2 == '\u252c' || c2 == '\u2534' || c2 == '\u253c' || c2 >= '\u2550' && c2 <= '\u256c' || c2 == '\u2580' || c2 == '\u2584' || c2 == '\u2588' || c2 == '\u258c' || c2 >= '\u2590' && c2 <= '\u2593' || c2 == '\u25a0' || c2 >= '\u25aa' && c2 <= '\u25ac' || c2 == '\u25b2' || c2 == '\u25ba' || c2 == '\u25bc' || c2 == '\u25c4' || c2 == '\u25c6' || c2 >= '\u25ca' && c2 <= '\u25cc' || c2 == '\u25cf' || c2 >= '\u25d7' && c2 <= '\u25d9' || c2 == '\u25e6' || c2 == '\u2605' || c2 == '\u260e' || c2 == '\u261b' || c2 == '\u261e' || c2 >= '\u263a' && c2 <= '\u263c' || c2 == '\u2640' || c2 == '\u2642' || c2 == '\u2660' || c2 == '\u2663' || c2 == '\u2665' || c2 == '\u2666' || c2 == '\u266a' || c2 == '\u266b' || c2 >= '\u2701' && c2 <= '\u2709' || c2 >= '\u270c' && c2 <= '\u2727' || c2 >= '\u2729' && c2 <= '\u274b' || c2 == '\u274d' || c2 >= '\u274f' && c2 <= '\u2752' || c2 == '\u2756' || c2 >= '\u2758' && c2 <= '\u275e' || c2 >= '\u2761' && c2 <= '\u2767' || c2 >= '\u2776' && c2 <= '\u2794' || c2 >= '\u2798' && c2 <= '\u27be' || c2 >= '\uf001' && c2 <= '\uf002' || c2 >= '\uf021' && c2 <= '\uf0ff' || c2 >= '\uf601' && c2 <= '\uf605' || c2 >= '\uf610' && c2 <= '\uf616' || c2 >= '\uf800' && c2 <= '\uf807' || c2 >= '\uf80a' && c2 <= '\uf80b' || c2 >= '\uf80e' && c2 <= '\uf811' || c2 >= '\uf814' && c2 <= '\uf815' || c2 >= '\uf81f' && c2 <= '\uf820' || c2 >= '\uf81f' && c2 <= '\uf820' || c2 == '\uf833';
    }

    @Override
    public void initWithParent() {
        this.controller.parent.registerMethod("mouseEvent", (Object)this);
    }

    protected void appendToRightOfCursor(char c) {
        this.appendToRightOfCursor("" + c);
    }

    protected void appendToRightOfCursor(String string) {
        String string2;
        String string3;
        if (this.startSelect != -1 && this.endSelect != -1) {
            int n;
            int n2 = Math.min(this.startSelect, this.endSelect);
            if (n2 >= (n = Math.max(this.startSelect, this.endSelect)) || n2 < 0 || n > this.contents.length()) {
                return;
            }
            string3 = this.contents.substring(0, n2);
            string2 = this.contents.substring(n);
            this.cursorPos = n2;
            this.endSelect = -1;
            this.startSelect = -1;
        } else {
            string3 = this.contents.substring(0, this.cursorPos);
            string2 = this.contents.substring(this.cursorPos);
        }
        this.contents = string3 + string + string2;
        this.cursorPos += string.length();
        if (this.controller.parent.textWidth(this.contents) < (float)(this.getWidth() - 12)) {
            this.visiblePortionStart = 0;
            this.visiblePortionEnd = this.contents.length();
        } else if (this.cursorPos == this.contents.length()) {
            this.visiblePortionEnd = this.cursorPos;
            this.adjustVisiblePortionStart();
        } else if (this.cursorPos >= this.visiblePortionEnd) {
            this.centerCursor();
        } else {
            this.adjustVisiblePortionEnd();
        }
        this.fireEventNotification(this, "Modified");
    }

    protected void backspaceChar() {
        if (this.startSelect != -1 && this.endSelect != -1) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos > 0) {
            this.deleteSubstring(this.cursorPos - 1, this.cursorPos);
        }
    }

    protected void deleteChar() {
        if (this.startSelect != -1 && this.endSelect != -1) {
            this.deleteSubstring(this.startSelect, this.endSelect);
        } else if (this.cursorPos < this.contents.length()) {
            this.deleteSubstring(this.cursorPos, this.cursorPos + 1);
        }
    }

    protected void deleteSubstring(int n, int n2) {
        int n3;
        int n4 = Math.min(n, n2);
        if (n4 >= (n3 = Math.max(n, n2)) || n4 < 0 || n3 > this.contents.length()) {
            return;
        }
        this.contents = this.contents.substring(0, n4) + this.contents.substring(n3);
        this.cursorPos = n4;
        if (this.controller.parent.textWidth(this.contents) < (float)(this.getWidth() - 12)) {
            this.visiblePortionStart = 0;
            this.visiblePortionEnd = this.contents.length();
        } else if (this.cursorPos == this.contents.length()) {
            this.visiblePortionEnd = this.cursorPos;
            this.adjustVisiblePortionStart();
        } else if (this.cursorPos <= this.visiblePortionStart) {
            this.centerCursor();
        } else {
            this.adjustVisiblePortionEnd();
        }
        this.endSelect = -1;
        this.startSelect = -1;
        this.fireEventNotification(this, "Modified");
    }

    protected void copySubstring(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        this.controller.copy(this.getValue().substring(n3, n4));
    }

    private void updateXPos() {
        this.cursorXPos = this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.cursorPos));
        if (this.startSelect != -1 && this.endSelect != -1) {
            int n;
            int n2;
            if (this.endSelect < this.startSelect) {
                n2 = this.endSelect;
                n = this.startSelect;
            } else {
                n2 = this.startSelect;
                n = this.endSelect;
            }
            this.startSelectXPos = n2 < this.visiblePortionStart ? 0.0f : this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, n2));
            this.endSelectXPos = n > this.visiblePortionEnd ? (float)(this.getWidth() - 4) : this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, n));
        }
    }

    private void adjustVisiblePortionStart() {
        if (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12)) {
            while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12) && this.visiblePortionStart != 0) {
                --this.visiblePortionStart;
            }
        } else {
            while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) > (float)(this.getWidth() - 12)) {
                ++this.visiblePortionStart;
            }
        }
    }

    private void adjustVisiblePortionEnd() {
        this.visiblePortionEnd = Math.min(this.visiblePortionEnd, this.contents.length());
        if (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12)) {
            while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12) && this.visiblePortionEnd != this.contents.length()) {
                ++this.visiblePortionEnd;
            }
        } else {
            while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) > (float)(this.getWidth() - 12)) {
                --this.visiblePortionEnd;
            }
        }
    }

    private void centerCursor() {
        this.visiblePortionStart = this.visiblePortionEnd = this.cursorPos;
        while (this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) < (float)(this.getWidth() - 12)) {
            if (this.visiblePortionStart != 0) {
                --this.visiblePortionStart;
            }
            if (this.visiblePortionEnd != this.contents.length()) {
                ++this.visiblePortionEnd;
            }
            if (this.visiblePortionEnd != this.contents.length() || this.visiblePortionStart != 0) continue;
            break;
        }
    }

    private int findClosestGap(int n) {
        float f = 0.0f;
        if (n < 0) {
            return this.visiblePortionStart;
        }
        if (n > this.getWidth()) {
            return this.visiblePortionEnd;
        }
        for (int i = this.visiblePortionStart; i < this.visiblePortionEnd; ++i) {
            float f2 = this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, i));
            if (f2 > (float)n) {
                if (f2 - (float)n < (float)n - f) {
                    return i;
                }
                return i - 1;
            }
            f = f2;
        }
        return this.contents.length();
    }

    public int getVisiblePortionStart() {
        return this.visiblePortionStart;
    }

    public void setVisiblePortionStart(int n) {
        this.visiblePortionStart = n;
    }

    public int getVisiblePortionEnd() {
        return this.visiblePortionEnd;
    }

    public void setVisiblePortionEnd(int n) {
        this.visiblePortionEnd = n;
    }

    public int getStartSelect() {
        return this.startSelect;
    }

    public void setStartSelect(int n) {
        this.startSelect = n;
    }

    public int getEndSelect() {
        return this.endSelect;
    }

    public void setEndSelect(int n) {
        this.endSelect = n;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setCursorPosition(int n) {
        this.cursorPos = n;
    }

    public void setValue(String string) {
        this.contents = string;
        this.cursorPos = this.contents.length();
        this.endSelect = -1;
        this.startSelect = -1;
        this.visiblePortionStart = 0;
        this.visiblePortionEnd = this.contents.length();
        if (this.controller != null && this.controller.parent.textWidth(this.contents) > (float)(this.getWidth() - 12)) {
            this.adjustVisiblePortionEnd();
        }
        this.fireEventNotification(this, "Set");
    }

    public String getValue() {
        return this.contents;
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        if (mouseEvent.getAction() == 1) {
            if (this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
                this.controller.requestFocus(this);
                this.wasClicked = true;
                this.endSelect = -1;
                this.startSelect = this.cursorPos = this.findClosestGap(mouseEvent.getX() - this.getX());
            } else if (this.controller.getFocusStatusForComponent(this)) {
                this.wasClicked = false;
                this.controller.yieldFocus(this);
                this.endSelect = -1;
                this.startSelect = -1;
            }
        } else if (mouseEvent.getAction() == 4) {
            this.endSelect = this.cursorPos = this.findClosestGap(mouseEvent.getX() - this.getX());
        } else if (mouseEvent.getAction() == 2 && this.endSelect == this.startSelect) {
            this.startSelect = -1;
            this.endSelect = -1;
        }
        this.updateXPos();
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        boolean bl = keyEvent.isShiftDown();
        if (keyEvent.getAction() == 1) {
            if (keyEvent.getKey() == '(') {
                if (bl) {
                    if (this.startSelect == -1) {
                        this.startSelect = this.cursorPos;
                    }
                    this.cursorPos = this.visiblePortionEnd = this.contents.length();
                    this.endSelect = this.visiblePortionEnd;
                } else {
                    this.endSelect = -1;
                    this.startSelect = -1;
                    this.cursorPos = this.visiblePortionEnd = this.contents.length();
                }
                this.adjustVisiblePortionStart();
            } else if (keyEvent.getKey() == '&') {
                if (bl) {
                    if (this.endSelect == -1) {
                        this.endSelect = this.cursorPos;
                    }
                    this.visiblePortionStart = 0;
                    this.cursorPos = 0;
                    this.startSelect = 0;
                } else {
                    this.endSelect = -1;
                    this.startSelect = -1;
                    this.visiblePortionStart = 0;
                    this.cursorPos = 0;
                }
                this.adjustVisiblePortionEnd();
            } else if (keyEvent.getKey() == '%') {
                if (bl) {
                    if (this.cursorPos > 0) {
                        if (this.startSelect != -1 && this.endSelect != -1) {
                            --this.startSelect;
                            --this.cursorPos;
                        } else {
                            this.endSelect = this.cursorPos--;
                            this.startSelect = this.cursorPos;
                        }
                    }
                } else if (this.startSelect != -1 && this.endSelect != -1) {
                    this.cursorPos = Math.min(this.startSelect, this.endSelect);
                    this.endSelect = -1;
                    this.startSelect = -1;
                } else if (this.cursorPos > 0) {
                    --this.cursorPos;
                }
                this.centerCursor();
            } else if (keyEvent.getKey() == '\'') {
                if (bl) {
                    if (this.cursorPos < this.contents.length()) {
                        if (this.startSelect != -1 && this.endSelect != -1) {
                            ++this.endSelect;
                            ++this.cursorPos;
                        } else {
                            this.startSelect = this.cursorPos++;
                            this.endSelect = this.cursorPos;
                        }
                    }
                } else if (this.startSelect != -1 && this.endSelect != -1) {
                    this.cursorPos = Math.max(this.startSelect, this.endSelect);
                    this.endSelect = -1;
                    this.startSelect = -1;
                } else if (this.cursorPos < this.contents.length()) {
                    ++this.cursorPos;
                }
                this.centerCursor();
            } else if (keyEvent.getKey() == '\u007f') {
                this.deleteChar();
            } else if (keyEvent.getKey() == '\n') {
                this.fireEventNotification(this, "Completed");
            } else if ((keyEvent.getModifiers() & n) == n) {
                switch (keyEvent.getKey()) {
                    case 'C': {
                        if (this.startSelect == -1 || this.endSelect == -1) break;
                        this.copySubstring(this.startSelect, this.endSelect);
                        break;
                    }
                    case 'V': {
                        this.appendToRightOfCursor(this.controller.paste());
                        break;
                    }
                    case 'X': {
                        if (this.startSelect == -1 || this.endSelect == -1) break;
                        this.copySubstring(this.startSelect, this.endSelect);
                        this.deleteSubstring(this.startSelect, this.endSelect);
                        break;
                    }
                    case 'A': {
                        this.startSelect = 0;
                        this.endSelect = this.contents.length();
                    }
                }
            }
        } else if (keyEvent.getAction() == 3 && (keyEvent.getModifiers() & n) != n) {
            if (keyEvent.getKey() == '\b') {
                this.backspaceChar();
            } else if (keyEvent.getKey() != '\uffff' && IFTextField.validUnicode(keyEvent.getKey())) {
                this.appendToRightOfCursor(keyEvent.getKey());
            }
        }
        this.updateXPos();
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    @Override
    public void draw() {
        boolean bl = this.controller.getFocusStatusForComponent(this);
        this.controller.parent.stroke(this.lookAndFeel.highlightColor);
        this.controller.parent.fill(this.lookAndFeel.borderColor);
        this.controller.parent.rect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight());
        this.controller.parent.noStroke();
        float f = this.cursorPos == this.contents.length() && this.controller.parent.textWidth(this.contents) > (float)(this.getWidth() - 8) ? (float)(this.getWidth() - 4) - this.controller.parent.textWidth(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd)) : 4.0f;
        if (bl && this.startSelect != -1 && this.endSelect != -1) {
            this.controller.parent.fill(this.lookAndFeel.selectionColor);
            this.controller.parent.rect((float)this.getX() + this.startSelectXPos + f, (float)(this.getY() + 3), this.endSelectXPos - this.startSelectXPos + 1.0f, 15.0f);
        }
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.text(this.contents.substring(this.visiblePortionStart, this.visiblePortionEnd), (float)this.getX() + f, (float)(this.getY() + 5), (float)(this.getWidth() - 8), (float)(this.getHeight() - 6));
        if (bl && (this.startSelect == -1 || this.endSelect == -1) && this.controller.parent.millis() % 1000 > 500) {
            this.controller.parent.stroke(this.lookAndFeel.darkGrayColor);
            this.controller.parent.line((float)(this.getX() + (int)this.cursorXPos) + f, (float)(this.getY() + 3), (float)(this.getX() + (int)this.cursorXPos) + f, (float)(this.getY() + 18));
        }
    }

    @Override
    public void actionPerformed(GUIEvent gUIEvent) {
        super.actionPerformed(gUIEvent);
        if (gUIEvent.getSource() == this) {
            if (gUIEvent.getMessage().equals("Received Focus")) {
                if (this.contents != "") {
                    this.startSelect = 0;
                    this.endSelect = this.contents.length();
                }
            } else if (gUIEvent.getMessage().equals("Lost Focus") && this.contents != "") {
                this.endSelect = -1;
                this.startSelect = -1;
            }
        }
    }
}

