/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.IFRadioButton;

public class IFRadioController
extends GUIComponent {
    private IFRadioButton[] contents;
    private int numItems = 0;
    private int selected = -1;

    public IFRadioController() {
        this.contents = new IFRadioButton[5];
    }

    public IFRadioController(String string) {
        this.setLabel(string);
        this.contents = new IFRadioButton[5];
    }

    public IFRadioController(String string, Object object) {
        this.setLabel(string);
        this.addActionListener(object);
        this.contents = new IFRadioButton[5];
    }

    public void add(IFRadioButton iFRadioButton) {
        if (this.numItems == this.contents.length) {
            IFRadioButton[] iFRadioButtonArray = this.contents;
            this.contents = new IFRadioButton[this.contents.length * 2];
            System.arraycopy(iFRadioButtonArray, 0, this.contents, 0, this.numItems);
        }
        this.contents[this.numItems++] = iFRadioButton;
    }

    public void remove(IFRadioButton iFRadioButton) {
        int n = -1;
        for (int i = 0; i < this.numItems; ++i) {
            if (iFRadioButton != this.contents[i]) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.contents[n] = null;
            if (n < this.numItems - 1) {
                System.arraycopy(this.contents, n + 1, this.contents, n, this.numItems);
            }
            --this.numItems;
        }
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public IFRadioButton getSelected() {
        if (this.selected >= 0 && this.selected < this.numItems) {
            return this.contents[this.selected];
        }
        return null;
    }

    public void selectButton(IFRadioButton iFRadioButton) {
        for (int i = 0; i < this.numItems; ++i) {
            if (this.contents[i] != iFRadioButton) continue;
            this.selected = i;
        }
        this.fireEventNotification(iFRadioButton, "Selected");
    }

    public boolean getSelectionStatusForButton(IFRadioButton iFRadioButton) {
        if (this.selected >= 0 && this.selected < this.numItems) {
            return iFRadioButton == this.contents[this.selected];
        }
        return false;
    }

    public void deselectAll() {
        this.selected = -1;
    }

    @Override
    public void addActionListener(Object object) {
        this.listener = object;
    }
}

