/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class IFCheckBox
extends GUIComponent {
    private int currentColor;
    private boolean selected = false;

    public IFCheckBox(String string, int n, int n2) {
        this.setLabel(string);
        this.setPosition(n, n2);
        this.setSize(14, 14);
    }

    @Override
    public void initWithParent() {
        this.controller.parent.registerMethod("mouseEvent", (Object)this);
        if (this.lookAndFeel == null) {
            return;
        }
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        this.setSize((int)Math.ceil(this.controller.parent.textWidth(this.getLabel())) + this.getHeight() + 5, 14);
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getAction() == 1) {
            if (this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
                this.wasClicked = true;
            }
        } else if (mouseEvent.getAction() == 2 && this.wasClicked && this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.selected) {
                this.selected = false;
                this.fireEventNotification(this, "Unchecked");
            } else {
                this.selected = true;
                this.fireEventNotification(this, "Checked");
            }
            this.wasClicked = false;
        }
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 3 && keyEvent.getKey() == ' ') {
            this.fireEventNotification(this, "Selected");
            if (this.selected) {
                this.selected = false;
                this.fireEventNotification(this, "Unchecked");
            } else {
                this.selected = true;
                this.fireEventNotification(this, "Checked");
            }
        }
    }

    @Override
    public void draw() {
        this.currentColor = this.isMouseOver(this.controller.parent.mouseX, this.controller.parent.mouseY) ? this.lookAndFeel.highlightColor : (this.controller.getFocusStatusForComponent(this) ? this.lookAndFeel.highlightColor : this.lookAndFeel.baseColor);
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        this.controller.parent.stroke(this.lookAndFeel.borderColor);
        this.controller.parent.fill(this.currentColor);
        this.controller.parent.rect((float)n, (float)n2, (float)n3, (float)n3);
        if (this.selected) {
            this.controller.parent.stroke(this.lookAndFeel.darkGrayColor);
            this.controller.parent.line((float)(n + 3), (float)(n2 + 2), (float)(n3 + n - 3), (float)(n3 + n2 - 4));
            this.controller.parent.line((float)(n + 3), (float)(n2 + 3), (float)(n3 + n - 4), (float)(n3 + n2 - 4));
            this.controller.parent.line((float)(n + 4), (float)(n2 + 2), (float)(n3 + n - 3), (float)(n3 + n2 - 5));
            this.controller.parent.line((float)(n + 3), (float)(n3 + n2 - 4), (float)(n3 + n - 3), (float)(n2 + 2));
            this.controller.parent.line((float)(n + 4), (float)(n3 + n2 - 4), (float)(n3 + n - 3), (float)(n2 + 3));
            this.controller.parent.line((float)(n + 3), (float)(n3 + n2 - 5), (float)(n3 + n - 4), (float)(n2 + 2));
        }
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.text(this.getLabel(), (float)(n3 + n + 5), (float)(n3 - 2 + n2));
        if (this.controller.showBounds) {
            this.controller.parent.noFill();
            this.controller.parent.stroke(255.0f, 0.0f, 0.0f);
            this.controller.parent.rect((float)n, (float)n2, (float)n4, (float)n3);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }
}

