/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.GUIEvent;
import interfascia.IFLookAndFeel;
import interfascia.IFPGraphicsState;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import processing.core.PApplet;
import processing.event.KeyEvent;

public class GUIController
extends GUIComponent
implements ClipboardOwner {
    private GUIComponent[] contents;
    private int numItems = 0;
    private int focusIndex = -1;
    private boolean visible;
    private IFLookAndFeel lookAndFeel;
    public IFPGraphicsState userState;
    private Clipboard clipboard;
    public PApplet parent;
    public boolean showBounds = false;

    public GUIController(PApplet pApplet) {
        this(pApplet, true);
    }

    public GUIController(PApplet pApplet, int n, int n2, int n3, int n4) {
        this(pApplet, true);
        this.setPosition(n, n2);
        this.setSize(n3, n4);
    }

    public GUIController(PApplet pApplet, boolean bl) {
        this.setParent(pApplet);
        this.setVisible(bl);
        this.contents = new GUIComponent[5];
        this.lookAndFeel = new IFLookAndFeel(this.parent, '\u0001');
        this.userState = new IFPGraphicsState();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                this.clipboard = new Clipboard("Interfascia Clipboard");
            }
        } else {
            try {
                this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pApplet.registerMethod("keyEvent", (Object)this);
        pApplet.registerMethod("draw", (Object)this);
    }

    @Override
    public void setLookAndFeel(IFLookAndFeel iFLookAndFeel) {
        this.lookAndFeel = iFLookAndFeel;
    }

    @Override
    public IFLookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void add(GUIComponent gUIComponent) {
        if (this.numItems == this.contents.length) {
            GUIComponent[] gUIComponentArray = this.contents;
            this.contents = new GUIComponent[this.contents.length * 2];
            System.arraycopy(gUIComponentArray, 0, this.contents, 0, this.numItems);
        }
        gUIComponent.setController(this);
        gUIComponent.setLookAndFeel(this.lookAndFeel);
        this.contents[this.numItems++] = gUIComponent;
        gUIComponent.initWithParent();
    }

    public void remove(GUIComponent gUIComponent) {
        int n = -1;
        for (int i = 0; i < this.numItems; ++i) {
            if (gUIComponent != this.contents[i]) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.contents[n] = null;
            if (n < this.numItems - 1) {
                System.arraycopy(this.contents, n + 1, this.contents, n, this.numItems - (n + 1));
            }
            --this.numItems;
        }
    }

    public void setParent(PApplet pApplet) {
        this.parent = pApplet;
    }

    public PApplet getParent() {
        return this.parent;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void requestFocus(GUIComponent gUIComponent) {
        for (int i = 0; i < this.numItems; ++i) {
            if (gUIComponent != this.contents[i]) continue;
            this.focusIndex = i;
        }
    }

    public void yieldFocus(GUIComponent gUIComponent) {
        if (this.focusIndex > -1 && this.focusIndex < this.numItems && this.contents[this.focusIndex] == gUIComponent) {
            this.focusIndex = -1;
        }
    }

    public GUIComponent getComponentWithFocus() {
        return this.contents[this.focusIndex];
    }

    public boolean getFocusStatusForComponent(GUIComponent gUIComponent) {
        if (this.focusIndex >= 0 && this.focusIndex < this.numItems) {
            return gUIComponent == this.contents[this.focusIndex];
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void copy(String string) {
        StringSelection stringSelection = new StringSelection(string);
        this.clipboard.setContents(stringSelection, this);
    }

    public String paste() {
        Transferable transferable = this.clipboard.getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (this.visible) {
            if (keyEvent.getAction() == 1 && keyEvent.getKeyCode() == 9) {
                if (this.focusIndex != -1 && this.contents[this.focusIndex] != null) {
                    this.contents[this.focusIndex].actionPerformed(new GUIEvent(this.contents[this.focusIndex], "Lost Focus"));
                }
                if (keyEvent.isShiftDown()) {
                    this.giveFocusToPreviousComponent();
                } else {
                    this.giveFocusToNextComponent();
                }
                if (this.focusIndex != -1 && this.contents[this.focusIndex] != null) {
                    this.contents[this.focusIndex].actionPerformed(new GUIEvent(this.contents[this.focusIndex], "Received Focus"));
                }
            } else if (keyEvent.getKeyCode() != 9 && this.focusIndex >= 0 && this.focusIndex < this.contents.length) {
                this.contents[this.focusIndex].keyEvent(keyEvent);
            }
        }
    }

    private void giveFocusToPreviousComponent() {
        int n = this.focusIndex;
        this.focusIndex = (this.focusIndex - 1) % this.numItems;
        while (!this.contents[this.focusIndex].canReceiveFocus() && this.focusIndex != n) {
            this.focusIndex = (this.focusIndex - 1) % this.numItems;
        }
    }

    private void giveFocusToNextComponent() {
        int n = this.focusIndex;
        this.focusIndex = (this.focusIndex + 1) % this.numItems;
        while (!this.contents[this.focusIndex].canReceiveFocus() && this.focusIndex != n) {
            this.focusIndex = (this.focusIndex + 1) % this.numItems;
        }
    }

    @Override
    public void draw() {
        if (this.visible) {
            this.userState.saveSettingsForApplet(this.parent);
            this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.parent);
            this.parent.fill(this.parent.color(0));
            this.parent.rect((float)this.getX(), (float)this.getY(), (float)this.getWidth(), (float)this.getHeight());
            for (int i = 0; i < this.contents.length; ++i) {
                if (this.contents[i] == null) continue;
                this.contents[i].draw();
            }
            this.userState.restoreSettingsToApplet(this.parent);
        }
    }
}

