/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIController;
import interfascia.GUIEvent;
import interfascia.IFDelegation;
import interfascia.IFLookAndFeel;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

abstract class GUIComponent {
    private int x;
    private int y;
    private int wid;
    private int hgt;
    private String label;
    protected boolean wasClicked = false;
    protected Object listener;
    protected IFLookAndFeel lookAndFeel;
    protected GUIController controller;
    protected int index;

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void update(int n, int n2) {
    }

    public void draw() {
    }

    public void setController(GUIController gUIController) {
        this.controller = gUIController;
    }

    public GUIController getController() {
        return this.controller;
    }

    public void initWithParent() {
    }

    public void setLookAndFeel(IFLookAndFeel iFLookAndFeel) {
        this.lookAndFeel = iFLookAndFeel;
    }

    public IFLookAndFeel getLookAndFeel() {
        return this.lookAndFeel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public boolean canReceiveFocus() {
        return true;
    }

    public int getWidth() {
        return this.wid;
    }

    public void setWidth(int n) {
        if (n > 0) {
            this.wid = n;
        }
    }

    public int getHeight() {
        return this.hgt;
    }

    public void setHeight(int n) {
        if (n > 0) {
            this.hgt = n;
        }
    }

    public void addActionListener(Object object) {
        this.listener = object;
    }

    public void setSize(int n, int n2) {
        if (n2 > 0 && n > 0) {
            this.hgt = n2;
            this.wid = n;
        }
    }

    public void setPosition(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            this.x = n;
            this.y = n2;
        }
    }

    public void setX(int n) {
        if (n >= 0) {
            this.x = n;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getAbsoluteX() {
        if (this.controller != null) {
            return this.controller.getAbsoluteX() + this.x;
        }
        return this.x;
    }

    public void setY(int n) {
        if (n >= 0) {
            this.y = n;
        }
    }

    public int getY() {
        return this.y;
    }

    public int getAbsoluteY() {
        if (this.controller != null) {
            return this.controller.getAbsoluteY() + this.y;
        }
        return this.y;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getAction() == 1) {
            if (this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
                this.wasClicked = true;
            }
        } else if (mouseEvent.getAction() == 2 && this.wasClicked && this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
            this.fireEventNotification(this, "Clicked");
            this.wasClicked = false;
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
    }

    public void actionPerformed(GUIEvent gUIEvent) {
    }

    public void fireEventNotification(GUIComponent gUIComponent, String string) {
        if (this.listener == null) {
            return;
        }
        GUIEvent gUIEvent = new GUIEvent(gUIComponent, string);
        IFDelegation.callDelegate(this.listener, "actionPerformed", new Object[]{gUIEvent});
    }

    public boolean isMouseOver(int n, int n2) {
        return n >= this.x && n2 >= this.y && n <= this.x + this.wid && n2 <= this.y + this.hgt;
    }
}

