/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import interfascia.GUIComponent;
import interfascia.GUIController;
import interfascia.GUIEvent;
import interfascia.IFButton;
import interfascia.IFTextField;
import java.io.File;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class SatelliteController
extends PApplet {
    int orbitRadius = 400;
    float orbitAngle = 0.0f;
    float orientAngle = 0.0f;
    float spinAngle = 0.0f;
    float spinSpeed = 0.0f;
    float pitchRemaining = 0.0f;
    float yawRemaining = 0.0f;
    float maneuveringSpeed = 0.5f;
    float fuelLevel = 0.9f;
    float fuelTankTemp = 1.0f;
    float fuelPipeTemp = 1.0f;
    float batteryLevel = 1.0f;
    float alignmentWithSun = 1.0f;
    boolean gyroscopeOn = false;
    boolean tankHeaterOn = false;
    boolean pipeHeaterOn = false;
    boolean scienceSensorsOn = true;
    boolean reacquiringSun = false;
    float solarPanelCutout = 0.25f;
    boolean pointAway = false;
    ArrayList<String> telemetryHistory = new ArrayList();
    boolean controlDown = false;
    boolean shiftDown = false;
    int gyroCountdown = -1;
    GUIController controller;
    IFTextField commandField;
    PImage sun;

    public void setup() {
        this.sun = this.loadImage("sun.png");
        this.imageMode(3);
        this.controller = new GUIController((PApplet)this);
        this.commandField = new IFTextField("Command", (this.width - 260) / 2, this.height - 40, 210);
        this.controller.add((GUIComponent)this.commandField);
        this.commandField.addActionListener((Object)this);
        IFButton sendButton = new IFButton("SEND", this.width - 215, this.height - 40, 60, 21);
        this.controller.add((GUIComponent)sendButton);
        sendButton.addActionListener((Object)this);
        this.loadState();
    }

    public void resetEverything() {
        this.orbitAngle = 0.0f;
        this.orientAngle = 0.0f;
        this.spinAngle = 0.0f;
        this.spinSpeed = 0.0f;
        this.pitchRemaining = 0.0f;
        this.yawRemaining = 0.0f;
        this.fuelLevel = 0.9f;
        this.fuelTankTemp = 1.0f;
        this.fuelPipeTemp = 1.0f;
        this.batteryLevel = 1.0f;
        this.gyroscopeOn = false;
        this.tankHeaterOn = false;
        this.pipeHeaterOn = false;
        this.scienceSensorsOn = true;
        this.reacquiringSun = false;
        this.pointAway = false;
    }

    public void saveState() {
        String[] values = new String[]{String.valueOf(this.orientAngle), String.valueOf(this.spinAngle), String.valueOf(this.spinSpeed), String.valueOf(this.fuelLevel), String.valueOf(this.fuelTankTemp), String.valueOf(this.fuelPipeTemp), String.valueOf(this.batteryLevel), String.valueOf(this.gyroscopeOn), String.valueOf(this.tankHeaterOn), String.valueOf(this.pipeHeaterOn), String.valueOf(this.scienceSensorsOn)};
        this.saveStrings(String.valueOf(System.getProperty("user.home")) + File.separator + ".state", values);
    }

    public void loadState() {
        String[] values = this.loadStrings(String.valueOf(System.getProperty("user.home")) + File.separator + ".state");
        if (values != null) {
            this.orientAngle = PApplet.parseFloat((String)values[0]);
            this.spinAngle = PApplet.parseFloat((String)values[1]);
            this.spinSpeed = PApplet.parseFloat((String)values[2]);
            this.fuelLevel = PApplet.parseFloat((String)values[3]);
            this.fuelTankTemp = PApplet.parseFloat((String)values[4]);
            this.fuelPipeTemp = PApplet.parseFloat((String)values[5]);
            this.batteryLevel = PApplet.parseFloat((String)values[6]);
            this.gyroscopeOn = PApplet.parseBoolean((String)values[7]);
            this.tankHeaterOn = PApplet.parseBoolean((String)values[8]);
            this.pipeHeaterOn = PApplet.parseBoolean((String)values[9]);
            this.scienceSensorsOn = PApplet.parseBoolean((String)values[10]);
        }
    }

    public void draw() {
        this.background(0);
        this.processDeepSpaceMessages();
        this.updateAngles();
        this.wrapAroundRotationAngles();
        this.calculateAlignmentWithSun();
        this.drawSun();
        this.drawTelemetryFeed();
        this.drawBatteryLevelIndicator();
        this.drawSignalStrengthIndicator();
        this.drawFuelGauge();
        this.drawTemperatureGauges();
        this.drawScienceIndicatorPanel();
        this.drawOrbitPath();
        this.drawSatellite();
        if (this.reacquiringSun) {
            this.tryToReacquireSun();
        }
        this.rechargeBattery();
        this.drainBatteryIfScienceOn();
        this.recalculateTemperatures();
        this.drawCommandPrompt();
        this.countDownGyro();
        if (this.frameCount % 60 == 0) {
            this.saveState();
        }
    }

    public void drainBatteryIfScienceOn() {
        if (this.alignmentWithSun < this.solarPanelCutout && this.scienceSensorsOn && this.batteryLevel > 0.0f) {
            this.batteryLevel -= 0.0015f;
        }
    }

    public void countDownGyro() {
        if (this.gyroscopeOn && this.gyroCountdown < 0) {
            this.gyroCountdown = 500;
        }
        if (this.gyroCountdown == 0) {
            this.gyroscopeOn = false;
        }
        if (this.gyroCountdown > -1) {
            --this.gyroCountdown;
        }
    }

    public void tryToReacquireSun() {
        if (this.canThrustersFire()) {
            if (this.gyroscopeOn) {
                this.reacquireSunSomeMore();
            } else {
                this.spinSpeed = 0.005f;
                this.pointAway = true;
            }
        } else {
            this.reacquiringSun = false;
        }
    }

    public void updateAngles() {
        this.orbitAngle += 0.01f;
        if (this.spinSpeed != 0.0f) {
            this.spinAngle += this.spinSpeed;
        }
        if (this.canThrustersFire()) {
            if (this.pointAway) {
                if (this.orientAngle < 1.45f) {
                    this.orientAngle += 0.01f;
                } else if (this.orientAngle > 1.55f) {
                    this.orientAngle -= 0.01f;
                } else {
                    this.pointAway = false;
                    this.reacquiringSun = false;
                    this.fuelTankTemp = 0.2f;
                    this.fuelPipeTemp = 0.2f;
                }
            }
            if (this.yawRemaining > 0.0f) {
                this.orientAngle += SatelliteController.radians((float)this.maneuveringSpeed);
                this.yawRemaining -= this.maneuveringSpeed;
            }
            if (this.yawRemaining < 0.0f) {
                this.orientAngle -= SatelliteController.radians((float)this.maneuveringSpeed);
                this.yawRemaining += this.maneuveringSpeed;
            }
            if (this.pitchRemaining > 0.0f) {
                this.spinAngle += SatelliteController.radians((float)this.maneuveringSpeed);
                this.pitchRemaining -= this.maneuveringSpeed;
            }
            if (this.pitchRemaining < 0.0f) {
                this.spinAngle -= SatelliteController.radians((float)this.maneuveringSpeed);
                this.pitchRemaining += this.maneuveringSpeed;
            }
        }
    }

    public void wrapAroundRotationAngles() {
        if (this.orbitAngle > (float)Math.PI * 2) {
            this.orbitAngle -= (float)Math.PI * 2;
        }
        if (this.spinAngle > (float)Math.PI * 2) {
            this.spinAngle -= (float)Math.PI * 2;
        }
        if (this.orientAngle > (float)Math.PI * 2) {
            this.orientAngle -= (float)Math.PI * 2;
        }
        if (this.orbitAngle < 0.0f) {
            this.orbitAngle = (float)Math.PI * 2 - this.orbitAngle;
        }
        if (this.spinAngle < 0.0f) {
            this.spinAngle = (float)Math.PI * 2 - this.spinAngle;
        }
        if (this.orientAngle < 0.0f) {
            this.orientAngle = (float)Math.PI * 2 - this.orientAngle;
        }
    }

    public void recalculateTemperatures() {
        if (this.alignmentWithSun < 0.5f) {
            if (this.fuelTankTemp > 0.0f) {
                this.fuelTankTemp -= 4.0E-5f;
            }
            if (this.fuelPipeTemp > 0.0f) {
                this.fuelPipeTemp -= 4.0E-5f;
            }
        }
        if (this.alignmentWithSun > 0.5f) {
            if (this.fuelTankTemp < 1.0f) {
                this.fuelTankTemp += 4.0E-5f;
            }
            if (this.fuelPipeTemp < 1.0f) {
                this.fuelPipeTemp += 4.0E-5f;
            }
        }
        if (this.tankHeaterOn && this.batteryLevel > 0.0f) {
            this.batteryLevel -= 0.001f;
            if (this.fuelTankTemp < 1.0f) {
                this.fuelTankTemp += 0.001f;
            }
        }
        if (this.pipeHeaterOn && this.batteryLevel > 0.0f) {
            this.batteryLevel -= 0.001f;
            if (this.fuelPipeTemp < 1.0f) {
                this.fuelPipeTemp += 0.001f;
            }
        }
    }

    public float proportionToDegreesC(float proportion) {
        return proportion * 25.0f - 21.0f;
    }

    public void rechargeBattery() {
        if (this.batteryLevel < 1.0f) {
            this.batteryLevel += SatelliteController.pow((float)this.alignmentWithSun, (float)0.001f) / 3000.0f;
        }
    }

    public Matrix rotationAboutX(float angle) {
        return new Matrix((double[][])new double[][]{{1.0, 0.0, 0.0}, {0.0, SatelliteController.cos((float)angle), SatelliteController.sin((float)angle)}, {0.0, -SatelliteController.sin((float)angle), SatelliteController.cos((float)angle)}});
    }

    public Matrix rotationAboutZ(float angle) {
        return new Matrix((double[][])new double[][]{{SatelliteController.cos((float)angle), SatelliteController.sin((float)angle), 0.0}, {-SatelliteController.sin((float)angle), SatelliteController.cos((float)angle), 0.0}, {0.0, 0.0, 1.0}});
    }

    public void calculateAlignmentWithSun() {
        PVector satalliteToSun = new PVector(SatelliteController.sin((float)this.orbitAngle), SatelliteController.cos((float)this.orbitAngle), 0.0f);
        satalliteToSun = satalliteToSun.normalize();
        Matrix normal = new Matrix((double[][])new double[][]{{0.0}, {1.0}, {0.0}});
        normal = this.rotationAboutX(this.spinAngle).times(normal);
        normal = this.rotationAboutZ(this.orbitAngle).times(normal);
        normal = this.rotationAboutZ(this.orientAngle).times(normal);
        PVector normalAsVector = new PVector((float)normal.get(0, 0), (float)normal.get(1, 0), (float)normal.get(2, 0));
        normalAsVector = normalAsVector.normalize();
        this.alignmentWithSun = normalAsVector.dot(satalliteToSun);
        if (this.alignmentWithSun < 0.0f) {
            this.alignmentWithSun = 0.0f;
        }
    }

    public void reacquireSunSomeMore() {
        if (this.spinSpeed != 0.0f) {
            this.spinSpeed = 0.0f;
        }
        this.wrapAroundRotationAngles();
        if (this.isVerySmall(this.spinAngle)) {
            this.spinAngle = 0.0f;
        } else if (this.spinAngle >= (float)Math.PI) {
            this.spinAngle += 0.0075f;
        } else if (this.spinAngle < (float)Math.PI) {
            this.spinAngle -= 0.0075f;
        }
        if (this.isVerySmall(this.orientAngle)) {
            this.orientAngle = 0.0f;
        } else if (this.orientAngle >= (float)Math.PI) {
            this.orientAngle += 0.0075f;
        } else if (this.orientAngle < (float)Math.PI) {
            this.orientAngle -= 0.0075f;
        }
        this.wrapAroundRotationAngles();
        if (this.spinAngle == 0.0f && this.orientAngle == 0.0f) {
            this.reacquiringSun = false;
        }
    }

    public boolean isVerySmall(float value) {
        return value < 0.01f && value > -0.01f;
    }

    public void keyPressed() {
        String currentValue = this.commandField.getValue();
        int pos = this.commandField.getCursorPosition();
        if (this.keyCode == 37 && pos > 0) {
            this.commandField.setCursorPosition(pos - 1);
        }
        if (this.keyCode == 39 && pos < currentValue.length()) {
            this.commandField.setCursorPosition(pos + 1);
        }
        if (this.keyCode == 8 && pos > 0) {
            this.commandField.setValue(String.valueOf(currentValue.substring(0, pos - 1)) + currentValue.substring(pos));
            this.commandField.setCursorPosition(pos - 1);
        }
        if (this.keyCode == 16) {
            this.shiftDown = true;
        }
        if (this.keyCode == 17 || this.keyCode == 157) {
            this.controlDown = true;
        }
        if (this.keyCode == 82 && this.controlDown && this.shiftDown) {
            this.resetEverything();
        }
    }

    public void keyReleased() {
        if (this.keyCode == 17 || this.keyCode == 157) {
            this.controlDown = false;
        }
        if (this.keyCode == 16) {
            this.shiftDown = false;
        }
    }

    public void actionPerformed(GUIEvent event) {
        String message = event.getMessage();
        if (message.equals("Completed") || message.equals("Clicked")) {
            this.processCommand(this.commandField.getValue());
            this.commandField.setValue("");
        }
    }

    public void processDeepSpaceMessages() {
        File file = new File(this.sketchPath("deepspace"));
        if (file.exists()) {
            String[] commands;
            String[] stringArray = commands = this.loadStrings(this.sketchPath("deepspace"));
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String command = stringArray[n2];
                this.processCommand(command.toUpperCase());
                ++n2;
            }
            file.delete();
        }
    }

    public void exportTemperatures() {
        float tankDegreesC = this.proportionToDegreesC(this.fuelTankTemp);
        float pipeDegreesC = this.proportionToDegreesC(this.fuelPipeTemp);
        String[] data = new String[]{"Tank: " + tankDegreesC + "\u00b0C", "Pipe: " + pipeDegreesC + "\u00b0C"};
        this.saveStrings("temperatures.txt", data);
    }

    public void exportBatteryLevel() {
        String[] data = new String[]{"Battery Level: " + PApplet.parseInt((float)(this.batteryLevel * 100.0f)) + "%"};
        this.saveStrings("battery.txt", data);
    }

    public void exportFuelTankLevel() {
        String[] data = new String[]{"Fuel Level: " + PApplet.parseInt((float)(this.fuelLevel * 100.0f)) + "%"};
        this.saveStrings("fuel.txt", data);
    }

    public void processCommand(String command) {
        if ((command = command.toUpperCase().trim()).startsWith("FTL")) {
            this.exportFuelTankLevel();
        }
        if (command.startsWith("TMP")) {
            this.exportTemperatures();
        }
        if (command.startsWith("BAT")) {
            this.exportBatteryLevel();
        }
        if (command.startsWith("RAD")) {
            this.exportRadarScan();
        }
        if (command.startsWith("ESR")) {
            this.reacquiringSun = true;
        }
        if (command.startsWith("GYR") && this.containsBool(command)) {
            this.gyroscopeOn = this.parseBool(command);
        }
        if (command.startsWith("FTH") && this.containsBool(command)) {
            this.tankHeaterOn = this.parseBool(command);
        }
        if (command.startsWith("FPH") && this.containsBool(command)) {
            this.pipeHeaterOn = this.parseBool(command);
        }
        if (command.startsWith("PIT")) {
            this.pitchRemaining = this.parseNumber(command);
        }
        if (command.startsWith("YAW")) {
            this.yawRemaining = this.parseNumber(command);
        }
        if (command.startsWith("SCI") && this.containsBool(command)) {
            this.scienceSensorsOn = this.parseBool(command);
        }
        this.saveState();
    }

    public boolean containsBool(String command) {
        if (command.length() < 4) {
            return false;
        }
        if (command.charAt(3) == '1') {
            return true;
        }
        return command.charAt(3) == '0';
    }

    public boolean parseBool(String command) {
        return command.charAt(3) != '0';
    }

    public float parseNumber(String command) {
        if (command.length() < 4) {
            return 0.0f;
        }
        try {
            return Integer.parseInt(command.substring(3));
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public void drawCommandPrompt() {
        if (this.alignmentWithSun > this.solarPanelCutout) {
            this.controller.setVisible(true);
        } else {
            this.controller.setVisible(false);
        }
    }

    public void drawBatteryLevelIndicator() {
        this.noFill();
        this.stroke(255);
        this.strokeWeight(1.5f);
        this.rect(22.0f, 14.0f, 20.0f, 11.0f);
        this.fill(255);
        this.rect(42.0f, 17.0f, 4.0f, 5.0f);
        if (this.alignmentWithSun > this.solarPanelCutout) {
            if (this.batteryLevel >= 0.7f) {
                this.fill(0.0f, 255.0f, 0.0f);
            } else if (this.batteryLevel >= 0.3f) {
                this.fill(255.0f, 180.0f, 0.0f);
            } else {
                this.fill(255.0f, 0.0f, 0.0f);
            }
            this.noStroke();
            this.rect(22.0f, 14.0f, 20.0f * this.batteryLevel, 11.0f);
        }
    }

    public void drawScienceIndicatorPanel() {
        String[] names = new String[]{"SUMER", "VIRGO", "GOLF", "COSTEP", "ERNE", "UVCS", "MDI", "LASCO", "EIT", "CDS", "SWAN", "CELIAS"};
        this.pushMatrix();
        this.textSize(14.0f);
        this.textAlign(37);
        this.translate(0.0f, 65 + this.height / 2);
        this.colorMode(3, 360.0f, 100.0f, 100.0f);
        int i = 0;
        while (i < names.length) {
            if (!this.scienceSensorsOn) {
                this.fill(50.0f, 0.0f, 50.0f);
                this.stroke(50.0f, 0.0f, 50.0f);
            } else if (this.alignmentWithSun < (float)names[i].length() / 10.0f) {
                this.fill(50.0f, 0.0f, 50.0f);
                this.stroke(50.0f, 0.0f, 50.0f);
            } else {
                this.fill(i * 28, 50.0f, 100.0f);
                this.stroke(i * 28, 50.0f, 100.0f);
            }
            this.rect(18.0f, 16 * i - 10, 10.0f, 10.0f);
            this.text(names[i], 33.0f, 16 * i);
            ++i;
        }
        this.colorMode(1, 255.0f, 255.0f, 255.0f);
        this.popMatrix();
    }

    public void drawSignalStrengthIndicator() {
        this.noFill();
        this.stroke(255);
        float triangleWidth = 20.0f;
        float trangleHeight = 15.0f;
        this.pushMatrix();
        this.translate(this.width - 40, 25.0f);
        this.triangle(0.0f, 0.0f, triangleWidth, -trangleHeight, triangleWidth, 0.0f);
        this.fill(255);
        float strength = SatelliteController.pow((float)this.alignmentWithSun, (float)5.0f);
        this.triangle(0.0f, 0.0f, triangleWidth * strength, -trangleHeight * strength, triangleWidth * strength, 0.0f);
        this.popMatrix();
    }

    public void drawTelemetryFeed() {
        if (this.alignmentWithSun > this.solarPanelCutout) {
            this.fill(0.0f, 200.0f, 0.0f);
            this.textSize(10.0f);
            this.textAlign(3);
            String levels = "ftl:" + this.fuelLevel + " ftt:" + this.fuelTankTemp + " bat:" + this.batteryLevel;
            String coords = "xyz:" + SatelliteController.sin((float)this.orbitAngle) + "," + SatelliteController.cos((float)this.orbitAngle) + "," + this.random(-1.0f, 1.0f);
            float signalStrength = SatelliteController.pow((float)this.alignmentWithSun, (float)5.0f);
            if (this.random(0.0f, 1.0f) < signalStrength) {
                this.telemetryHistory.add(String.valueOf(coords) + " " + levels);
            }
            if (this.telemetryHistory.size() > 8) {
                this.telemetryHistory.remove(0);
            }
            int i = 0;
            while (i < this.telemetryHistory.size()) {
                this.text(this.telemetryHistory.get(0), this.width / 2, 10 * i);
                ++i;
            }
        }
    }

    public void drawSun() {
        this.image(this.sun, this.width / 2, this.height / 2);
    }

    public void drawOrbitPath() {
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.translate(0.0f, 0.0f, -500.0f);
        this.stroke(80);
        this.noFill();
        this.ellipse(0.0f, 0.0f, this.orbitRadius * 2, this.orbitRadius * 2);
        this.popMatrix();
    }

    public void drawSatellite() {
        if (this.alignmentWithSun > 0.75f || this.alignmentWithSun > 0.25f && this.random(0.0f, 1.0f) < this.alignmentWithSun) {
            this.pushMatrix();
            this.lights();
            this.translate(this.width / 2, this.height / 2);
            this.rotateZ(-this.orbitAngle);
            this.translate(0.0f, this.orbitRadius - 10, -500.0f);
            this.noStroke();
            this.rotateX(this.spinAngle + 0.3f);
            this.rotateZ(this.orientAngle);
            this.translate(0.0f, -50.0f);
            this.fill(255.0f, 200.0f, 0.0f);
            this.box(50.0f, 50.0f, 50.0f);
            this.translate(0.0f, 30.0f);
            this.fill(200);
            this.box(30.0f, 100.0f, 30.0f);
            this.translate(0.0f, 30.0f);
            this.box(55.0f, 30.0f, 55.0f);
            this.translate(0.0f, 15.0f);
            if ((this.reacquiringSun || this.pointAway || this.pitchRemaining != 0.0f || this.yawRemaining != 0.0f) && this.canThrustersFire()) {
                this.fill(255.0f, this.random(0.0f, 255.0f), 0.0f);
                this.sphere(this.random(10.0f, 20.0f));
                this.fuelLevel -= 0.001f;
            }
            this.translate(-90.0f, 0.0f);
            this.fill(120.0f, 120.0f, 255.0f);
            int i = 0;
            while (i < 4) {
                this.box(50.0f, 5.0f, 80.0f);
                this.translate(60.0f, 0.0f);
                ++i;
            }
            this.popMatrix();
        }
    }

    public boolean canThrustersFire() {
        if (this.fuelLevel <= 0.0f) {
            return false;
        }
        if (this.proportionToDegreesC(this.fuelTankTemp) < 2.0f) {
            return false;
        }
        return !(this.proportionToDegreesC(this.fuelPipeTemp) < 2.0f);
    }

    public void drawFuelGauge() {
        this.noStroke();
        this.fill(100);
        if (this.alignmentWithSun > this.solarPanelCutout) {
            this.rect(this.width - 40, this.height - 100, 20.0f, (float)(-this.height + 200) * this.fuelLevel);
        }
        this.stroke(255);
        this.noFill();
        this.rect(this.width - 40, this.height - 100, 20.0f, -this.height + 200);
        this.fill(255);
        this.textSize(18.0f);
        this.textAlign(3);
        this.text("Fuel", this.width - 30, this.height - 78);
    }

    public void drawTemperatureGauges() {
        this.pushMatrix();
        this.colorMode(3, 360.0f, 100.0f, 100.0f);
        if (this.alignmentWithSun > this.solarPanelCutout) {
            int i = 0;
            while (i < 240) {
                this.stroke(240 - i, 100.0f, 100.0f);
                if (this.fuelTankTemp * 240.0f > (float)i) {
                    this.line(20.0f, this.height - 380 - i / 2, 32.0f, this.height - 380 - i / 2);
                }
                if (this.fuelPipeTemp * 240.0f > (float)i) {
                    this.line(40.0f, this.height - 380 - i / 2, 52.0f, this.height - 380 - i / 2);
                }
                ++i;
            }
        }
        this.colorMode(1, 255.0f, 255.0f, 255.0f);
        this.stroke(255);
        this.noFill();
        this.rect(20.0f, this.height - 380, 12.0f, -this.height + 480);
        this.rect(40.0f, this.height - 380, 12.0f, -this.height + 480);
        this.stroke(255);
        this.fill(255);
        this.textSize(18.0f);
        this.textAlign(3);
        this.text("Temp", 36.0f, 90.0f);
        this.rotate(-1.5707964f);
        this.text("Tank", -244.0f, 30.0f);
        this.text("Pipe", -244.0f, 50.0f);
        this.popMatrix();
    }

    public void exportRadarScan() {
        PImage scan = this.createImage(this.width, this.height, 1);
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                scan.set(x, y, this.color(this.random(0.0f, 230.0f)));
                ++y;
            }
            ++x;
        }
        int i = 0;
        while (i < 2000) {
            float angle = this.random(0.0f, (float)Math.PI * 2);
            float distance = this.random(0.0f, 20.0f);
            scan.set(PApplet.parseInt((float)(distance * SatelliteController.sin((float)angle))) + this.width / 2, PApplet.parseInt((float)(distance * SatelliteController.cos((float)angle))) + this.height / 2, this.color(255));
            ++i;
        }
        int xpos = this.width / 2 + PApplet.parseInt((float)(SatelliteController.sin((float)this.orbitAngle) * (float)this.orbitRadius / 2.0f));
        int ypos = this.height / 2 + PApplet.parseInt((float)(SatelliteController.cos((float)this.orbitAngle) * (float)this.orbitRadius / 2.0f));
        int x2 = -2;
        while (x2 < 2) {
            int y = -2;
            while (y < 2) {
                scan.set(xpos + x2, ypos + y, this.color(255));
                ++y;
            }
            ++x2;
        }
        scan.save(this.sketchPath("radarscan.png"));
    }

    public void settings() {
        this.size(600, 600, "processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"SatelliteController"};
        if (passedArgs != null) {
            PApplet.main((String[])SatelliteController.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

