/*
 * Decompiled with CFR 0.152.
 */
package interfascia;

import interfascia.GUIComponent;
import interfascia.IFRadioController;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class IFRadioButton
extends GUIComponent {
    private int currentColor;
    private IFRadioController radioController;

    public IFRadioButton(String string, int n, int n2, IFRadioController iFRadioController) {
        this.setLabel(string);
        this.setPosition(n, n2 + 1);
        this.setSize(15, 15);
        this.radioController = iFRadioController;
        this.radioController.add(this);
    }

    @Override
    public void initWithParent() {
        this.controller.parent.registerMethod("mouseEvent", (Object)this);
        if (this.lookAndFeel == null) {
            return;
        }
        this.controller.userState.saveSettingsForApplet(this.controller.parent);
        this.lookAndFeel.defaultGraphicsState.restoreSettingsToApplet(this.controller.parent);
        this.setSize((int)Math.ceil(this.controller.parent.textWidth(this.getLabel())) + this.getHeight() + 5, 14);
        this.controller.userState.restoreSettingsToApplet(this.controller.parent);
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getAction() == 1) {
            if (this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
                this.wasClicked = true;
            }
        } else if (mouseEvent.getAction() == 2 && this.wasClicked && this.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
            this.radioController.selectButton(this);
            this.wasClicked = false;
        }
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 3 && keyEvent.getKey() == ' ') {
            this.radioController.selectButton(this);
        }
    }

    @Override
    public void draw() {
        this.currentColor = this.isMouseOver(this.controller.parent.mouseX, this.controller.parent.mouseY) ? this.lookAndFeel.highlightColor : (this.controller.getFocusStatusForComponent(this) ? this.lookAndFeel.highlightColor : this.lookAndFeel.baseColor);
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        this.controller.parent.stroke(this.lookAndFeel.borderColor);
        this.controller.parent.fill(this.currentColor);
        this.controller.parent.ellipse((float)n, (float)n2, (float)n3, (float)n3);
        if (this.radioController.getSelectionStatusForButton(this)) {
            this.controller.parent.fill(this.lookAndFeel.lightGrayColor);
            this.controller.parent.ellipse((float)(n + 2), (float)(n2 + 2), (float)(n3 - 4), (float)(n3 - 4));
        }
        this.controller.parent.fill(this.lookAndFeel.textColor);
        this.controller.parent.text(this.getLabel(), (float)(n3 + n + 5), (float)(n3 - 3 + n2));
        if (this.controller.showBounds) {
            this.controller.parent.noFill();
            this.controller.parent.stroke(255.0f, 0.0f, 0.0f);
            this.controller.parent.rect((float)n, (float)n2, (float)n4, (float)n3);
        }
    }

    public boolean isSelected() {
        return this.radioController.getSelectionStatusForButton(this);
    }

    public void setSelected() {
        this.radioController.selectButton(this);
    }
}

